/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.session;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.jdbc.Work;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.session.Domain;
import org.hibernate.search.test.session.Email;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class MassIndexUsingManualFlushTest
extends SearchTestBase {
    @Test
    public void testManualIndexFlush() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        int loop = 14;
        s.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                for (int i = 0; i < 14; ++i) {
                    Statement statmt = connection.createStatement();
                    statmt.executeUpdate("insert into Domain(id, name) values( + " + (i + 1) + ", 'sponge" + i + "')");
                    statmt.executeUpdate("insert into Email(id, title, body, header, domain_id) values( + " + (i + 1) + ", 'Bob Sponge', 'Meet the guys who create the software', 'nope', " + (i + 1) + ")");
                    statmt.close();
                }
            }
        });
        tx.commit();
        s.close();
        s = Search.getFullTextSession((Session)this.openSession());
        tx = s.beginTransaction();
        ScrollableResults results = s.createCriteria(Email.class).scroll(ScrollMode.FORWARD_ONLY);
        int index = 0;
        while (results.next()) {
            Email o = (Email)results.get(0);
            s.index((Object)o);
            if (++index % 5 != 0) continue;
            s.flushToIndexes();
            s.clear();
        }
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
        List result = s.createFullTextQuery(parser.parse("body:create"), new Class[0]).list();
        Assert.assertEquals((long)14L, (long)result.size());
        for (Object object : result) {
            s.delete(object);
        }
        tx.commit();
        s.close();
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.analyzer", StopAnalyzer.class.getName());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Email.class, Domain.class};
    }
}

