/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.fest.assertions.Assertions;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.hcore.impl.HibernateSessionFactoryService;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.ShardIdentifierProviderTemplate;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.shards.Animal;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DynamicShardingTest
extends SearchTestBase {
    private Animal elephant;
    private Animal spider;
    private Animal bear;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.elephant = new Animal();
        this.elephant.setId(1);
        this.elephant.setName("Elephant");
        this.elephant.setType("Mammal");
        this.spider = new Animal();
        this.spider.setId(2);
        this.spider.setName("Spider");
        this.spider.setType("Insect");
        this.bear = new Animal();
        this.bear.setId(3);
        this.bear.setName("Bear");
        this.bear.setType("Mammal");
    }

    @Test
    public void testDynamicCreationOfShards() throws Exception {
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)this.getExtendedSearchIntegrator().getIndexBindings().get(Animal.class);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(0);
        this.insertAnimals(this.elephant);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(1);
        this.insertAnimals(this.spider);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(2);
        this.insertAnimals(this.bear);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(2);
        this.assertNumberOfEntitiesInIndex("Animal.Mammal", 2);
        this.assertNumberOfEntitiesInIndex("Animal.Insect", 1);
    }

    @Test
    public void testDynamicShardsAreTargetingInQuery() throws Exception {
        this.insertAnimals(this.elephant, this.spider, this.bear);
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fts = Search.getFullTextSession((Session)session);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
        List results = fts.createFullTextQuery(parser.parse("name:bear OR name:elephant OR name:spider"), new Class[0]).list();
        Assert.assertEquals((String)"Either double insert, single update, or query fails with shards", (long)3L, (long)results.size());
        tx.commit();
        session.close();
    }

    @Test
    public void testInitialiseDynamicShardsOnStartup() throws Exception {
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)this.getExtendedSearchIntegrator().getIndexBindings().get(Animal.class);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(0);
        this.insertAnimals(this.elephant, this.spider, this.bear);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(2);
        Assertions.assertThat((Object[])this.getIndexManagersAfterReopening()).hasSize(2);
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.Animal.sharding_strategy", AnimalShardIdentifierProvider.class.getName());
        cfg.put("hibernate.search.default.directory_provider", "filesystem");
        Path sub = this.getBaseIndexDir();
        cfg.put("hibernate.search.default.indexBase", sub.toAbsolutePath().toString());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Animal.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNumberOfEntitiesInIndex(String indexName, int expectedCount) throws IOException {
        try (FSDirectory fsDirectory = FSDirectory.open((File)this.getBaseIndexDir().resolve(indexName).toFile());
             DirectoryReader reader = DirectoryReader.open((Directory)fsDirectory);){
            int actualCount = reader.numDocs();
            Assert.assertEquals((String)"Unexpected document count", (long)expectedCount, (long)actualCount);
        }
    }

    private void insertAnimals(Animal ... animals) {
        try (Session session = this.openSession();){
            Transaction tx = session.beginTransaction();
            for (Animal animal : animals) {
                session.persist((Object)animal);
            }
            tx.commit();
        }
    }

    /*
     * Exception decompiling
     */
    private IndexManager[] getIndexManagersAfterReopening() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class AnimalShardIdentifierProvider
    extends ShardIdentifierProviderTemplate {
        public String getShardIdentifier(Class<?> entityType, Serializable id, String idAsString, Document document) {
            if (entityType.equals(Animal.class)) {
                String typeValue = document.getField("type").stringValue();
                this.addShard(typeValue);
                return typeValue;
            }
            throw new RuntimeException("Animal expected but found " + entityType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set<String> loadInitialShardNames(Properties properties, BuildContext buildContext) {
            ServiceManager serviceManager = buildContext.getServiceManager();
            SessionFactory sessionFactory = ((HibernateSessionFactoryService)serviceManager.requestService(HibernateSessionFactoryService.class)).getSessionFactory();
            try (Session session = sessionFactory.openSession();){
                Criteria initialShardsCriteria = session.createCriteria(Animal.class);
                initialShardsCriteria.setProjection(Projections.distinct((Projection)Property.forName((String)"type")));
                List initialTypes = initialShardsCriteria.list();
                HashSet<String> hashSet = new HashSet<String>(initialTypes);
                return hashSet;
            }
        }
    }
}

