/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;

public class DateSplitBridge
implements FieldBridge {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        Date date = (Date)value;
        Calendar cal = GregorianCalendar.getInstance(GMT, Locale.ROOT);
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        luceneOptions.addFieldToDocument(name + ".year", String.valueOf(year), document);
        luceneOptions.addFieldToDocument(name + ".month", month < 10 ? "0" : "" + String.valueOf(month), document);
        luceneOptions.addFieldToDocument(name + ".day", day < 10 ? "0" : "" + String.valueOf(day), document);
    }
}

