/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.ngram.NGramFilterFactory;
import org.apache.lucene.analysis.snowball.SnowballPorterFilterFactory;
import org.apache.lucene.analysis.standard.StandardFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.builtin.impl.String2FieldBridgeAdaptor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.RangeMatchingContext;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.query.dsl.Unit;
import org.hibernate.search.query.dsl.impl.ConnectedTermMatchingContext;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.dsl.Animal;
import org.hibernate.search.test.query.dsl.Car;
import org.hibernate.search.test.query.dsl.Coffee;
import org.hibernate.search.test.query.dsl.CoffeeBrand;
import org.hibernate.search.test.query.dsl.Day;
import org.hibernate.search.test.query.dsl.Month;
import org.hibernate.search.test.query.dsl.POI;
import org.hibernate.search.test.query.dsl.RomanNumberFieldBridge;
import org.hibernate.search.test.query.dsl.SportsCar;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DSLTest
extends SearchTestBase {
    private static final Log log = LoggerFactory.make();
    private final Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
    private FullTextSession fullTextSession;
    private Date february;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.indexTestData();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testUseOfFieldBridge() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().onField("monthValue").matching((Object)2).createQuery();
        Assert.assertEquals((long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    @Test
    public void testUseOfCustomFieldBridgeInstance() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        ConnectedTermMatchingContext termMatchingContext = (ConnectedTermMatchingContext)monthQb.keyword().onField("monthValueAsRomanNumberFromClassBridge1");
        Query query = termMatchingContext.withFieldBridge((FieldBridge)new String2FieldBridgeAdaptor((StringBridge)new RomanNumberFieldBridge())).matching((Object)2).createQuery();
        Assert.assertEquals((long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    @Test
    public void testUseOfMultipleCustomFieldBridgeInstances() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        ConnectedTermMatchingContext field1Context = (ConnectedTermMatchingContext)monthQb.keyword().onField("monthValueAsRomanNumberFromClassBridge1");
        ConnectedTermMatchingContext field2Context = (ConnectedTermMatchingContext)field1Context.withFieldBridge((FieldBridge)new String2FieldBridgeAdaptor((StringBridge)new RomanNumberFieldBridge())).andField("monthValueAsRomanNumberFromClassBridge2");
        Query query = field2Context.withFieldBridge((FieldBridge)new String2FieldBridgeAdaptor((StringBridge)new RomanNumberFieldBridge())).matching((Object)2).createQuery();
        Assert.assertEquals((long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    @Test
    public void testTermQueryOnAnalyzer() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().onField("mythology").matching((Object)"cold").createQuery();
        Assert.assertEquals((long)0L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.keyword().onField("mythology").matching((Object)"colder darker").createQuery();
        Assert.assertEquals((long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.keyword().onField("mythology_stem").matching((Object)"snowboard").createQuery();
        Assert.assertEquals((long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.keyword().onField("mythology_ngram").matching((Object)"snobored").createQuery();
        Assert.assertEquals((long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = ((TermMatchingContext)monthQb.keyword().onField("mythology").ignoreAnalyzer()).matching((Object)"Month").createQuery();
        Assert.assertEquals((long)0L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    @Test
    public void testFuzzyQuery() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().fuzzy().withEditDistanceUpTo(1).withPrefixLength(1).onField("mythology").matching((Object)"calder").createQuery();
        Assert.assertEquals((long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    @Test
    public void testFuzzyQueryOnMultipleFields() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().fuzzy().withEditDistanceUpTo(2).withPrefixLength(1).onFields(new String[]{"mythology", "history"}).matching((Object)"showboarding").createQuery();
        Assert.assertEquals((long)2L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    @Test
    public void testWildcardQuery() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().wildcard().onField("mythology").matching((Object)"mon*").createQuery();
        Assert.assertEquals((long)3L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1811")
    public void testWildcardQueryOnMultipleFields() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().wildcard().onFields(new String[]{"mythology", "history"}).matching((Object)"snowbo*").createQuery();
        Assertions.assertThat((List)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list()).onProperty("name").containsOnly(new Object[]{"February", "March"});
        transaction.commit();
    }

    @Test
    public void testQueryCustomization() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.bool().should(monthQb.keyword().onField("mythology").matching((Object)"whitening").createQuery()).should(monthQb.keyword().onField("history").matching((Object)"whitening").createQuery()).createQuery();
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)"January", (Object)((Month)results.get(0)).getName());
        query = monthQb.bool().should(monthQb.keyword().onField("mythology").matching((Object)"whitening").createQuery()).should(((TermMatchingContext)monthQb.keyword().onField("history").boostedTo(30.0f)).matching((Object)"whitening").createQuery()).createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)"February", (Object)((Month)results.get(0)).getName());
        transaction.commit();
    }

    @Test
    public void testMultipleFields() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().onField("mythology").andField("history").matching((Object)"whitening").createQuery();
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)"January", (Object)((Month)results.get(0)).getName());
        query = ((TermMatchingContext)monthQb.keyword().onFields(new String[]{"mythology", "history"}).boostedTo(30.0f)).matching((Object)"whitening").createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)"January", (Object)((Month)results.get(0)).getName());
        query = ((TermMatchingContext)monthQb.keyword().onField("mythology").andField("history").boostedTo(30.0f)).matching((Object)"whitening").createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)"February", (Object)((Month)results.get(0)).getName());
        transaction.commit();
    }

    @Test
    public void testBoolean() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.bool().must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).createQuery();
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"January", (Object)((Month)results.get(0)).getName());
        query = monthQb.bool().should(monthQb.all().createQuery()).must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).not().createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)"February", (Object)((Month)results.get(0)).getName());
        Assert.assertEquals((Object)"March", (Object)((Month)results.get(1)).getName());
        query = monthQb.bool().must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).not().createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)"February", (Object)((Month)results.get(0)).getName());
        Assert.assertEquals((Object)"March", (Object)((Month)results.get(1)).getName());
        query = monthQb.all().except(new Query[]{monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()}).createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)"February", (Object)((Month)results.get(0)).getName());
        Assert.assertEquals((Object)"March", (Object)((Month)results.get(1)).getName());
        transaction.commit();
    }

    @Test(expected=SearchException.class)
    public void testIllegalBooleanJunction() {
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        BooleanJunction booleanJunction = monthQb.bool();
        Assert.assertTrue((boolean)booleanJunction.isEmpty());
        booleanJunction.createQuery();
        Assert.fail((String)"should not reach this point");
    }

    @Test
    public void testRangeQueryFromTo() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1900, 2, 12, 0, 0, 0);
        this.calendar.set(14, 0);
        Date from = this.calendar.getTime();
        this.calendar.set(1910, 2, 12, 0, 0, 0);
        Date to = this.calendar.getTime();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).from((Object)from).to((Object)to).excludeLimit().createQuery();
        Assert.assertEquals((long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = ((RangeMatchingContext)((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").ignoreFieldBridge()).andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).from((Object)DateTools.round((Date)from, (DateTools.Resolution)DateTools.Resolution.MINUTE)).to((Object)DateTools.round((Date)to, (DateTools.Resolution)DateTools.Resolution.MINUTE)).excludeLimit().createQuery();
        Assert.assertEquals((long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    @Test
    public void testRangeQueryBelow() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1810, 2, 12, 0, 0, 0);
        Date to = this.calendar.getTime();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).below((Object)to).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        Assert.assertEquals((long)1L, (long)hibQuery.getResultSize());
        Assert.assertEquals((Object)"March", (Object)((Month)hibQuery.list().get(0)).getName());
        query = ((RangeMatchingContext)((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").ignoreFieldBridge()).andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).below((Object)DateTools.round((Date)to, (DateTools.Resolution)DateTools.Resolution.MINUTE)).createQuery();
        hibQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        Assert.assertEquals((long)1L, (long)hibQuery.getResultSize());
        Assert.assertEquals((Object)"March", (Object)((Month)hibQuery.list().get(0)).getName());
        query = monthQb.range().onField("raindropInMm").below((Object)0.24).createQuery();
        Assert.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assert.assertEquals((String)"test range numeric ", (long)1L, (long)results.size());
        Assert.assertEquals((String)"test range numeric ", (Object)"January", (Object)((Month)results.get(0)).getName());
        transaction.commit();
    }

    @Test
    public void testRangeQueryAbove() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1910, 2, 12, 0, 0, 0);
        Date to = this.calendar.getTime();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).above((Object)to).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        Assert.assertEquals((long)1L, (long)hibQuery.getResultSize());
        Assert.assertEquals((Object)"February", (Object)((Month)hibQuery.list().get(0)).getName());
        query = ((RangeMatchingContext)((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").ignoreFieldBridge()).andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).above((Object)DateTools.round((Date)to, (DateTools.Resolution)DateTools.Resolution.MINUTE)).createQuery();
        hibQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        Assert.assertEquals((long)1L, (long)hibQuery.getResultSize());
        Assert.assertEquals((Object)"February", (Object)((Month)hibQuery.list().get(0)).getName());
        transaction.commit();
    }

    @Test
    public void testRangeQueryAboveInclusive() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).above((Object)this.february).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        Assert.assertEquals((String)"Wrong number of query results", (long)1L, (long)hibQuery.getResultSize());
        Assert.assertEquals((Object)"February", (Object)((Month)hibQuery.list().get(0)).getName());
        transaction.commit();
    }

    @Test
    public void testRangeQueryAboveExclusive() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).above((Object)this.february).excludeLimit().createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        Assert.assertEquals((long)0L, (long)hibQuery.getResultSize());
        transaction.commit();
    }

    @Test
    public void testPhraseQuery() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.phrase().onField("mythology").sentence("colder and whitening").createQuery();
        Assert.assertEquals((String)"test exact phrase", (long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.phrase().onField("mythology").sentence("Month whitening").createQuery();
        Assert.assertEquals((String)"test slop", (long)0L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.phrase().withSlop(3).onField("mythology").sentence("Month whitening").createQuery();
        Assert.assertEquals((String)"test slop", (long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.phrase().onField("mythology").sentence("whitening").createQuery();
        Assert.assertEquals((String)"test one term optimization", (long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1074")
    public void testPhraseQueryWithNoTermsAfterAnalyzerApplication() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.phrase().onField("mythology").sentence("and").createQuery();
        Assert.assertEquals((String)"there should be no results, since all terms are stop words", (long)0L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    @Test
    public void testNumericRangeQueries() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.range().onField("raindropInMm").from((Object)0.23).to((Object)0.24).createQuery();
        Assert.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assert.assertEquals((String)"test range numeric ", (long)1L, (long)results.size());
        Assert.assertEquals((String)"test range numeric ", (Object)"January", (Object)((Month)results.get(0)).getName());
        transaction.commit();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1378")
    public void testNumericRangeQueryAbove() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.range().onField("raindropInMm").above((Object)0.231).createQuery();
        Assert.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assertions.assertThat((List)results).onProperty("name").containsOnly(new Object[]{"January", "February", "March"});
        query = monthQb.range().onField("raindropInMm").above((Object)0.231).excludeLimit().createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assertions.assertThat((List)results).onProperty("name").containsOnly(new Object[]{"February", "March"});
        transaction.commit();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1378")
    public void testNumericRangeQueryBelow() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.range().onField("raindropInMm").below((Object)0.435).createQuery();
        Assert.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assertions.assertThat((List)results).onProperty("name").containsOnly(new Object[]{"January", "February", "March"});
        query = monthQb.range().onField("raindropInMm").below((Object)0.435).excludeLimit().createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        Assertions.assertThat((List)results).onProperty("name").containsOnly(new Object[]{"January"});
        transaction.commit();
    }

    @Test
    public void testNumericFieldsTermQuery() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().onField("raindropInMm").matching((Object)0.231).createQuery();
        Assert.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        Assert.assertEquals((String)"test term numeric ", (long)1L, (long)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    @Test
    public void testFieldBridge() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().onField("monthRomanNumber").matching((Object)2).createQuery();
        FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        List results = fullTextQuery.list();
        Assert.assertEquals((long)1L, (long)results.size());
        Month february = (Month)results.get(0);
        Assert.assertEquals((long)2L, (long)february.getMonthValue());
        transaction.commit();
    }

    @Test
    public void testSpatialQueries() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Point coordinates = Point.fromDegrees((double)24.0, (double)31.5);
        Query query = builder.spatial().onField("location").within(51.0, Unit.KM).ofCoordinates((Coordinates)coordinates).createQuery();
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{POI.class}).list();
        Assert.assertEquals((String)"test spatial hash based spatial query", (long)1L, (long)results.size());
        Assert.assertEquals((String)"test spatial hash based spatial query", (Object)"Bozo", (Object)((POI)results.get(0)).getName());
        query = builder.spatial().onField("location").within(500.0, Unit.KM).ofLatitude(48.858333).andLongitude(2.294444).createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{POI.class}).list();
        Assert.assertEquals((String)"test spatial hash based spatial query", (long)1L, (long)results.size());
        Assert.assertEquals((String)"test spatial hash based spatial query", (Object)"Tour Eiffel", (Object)((POI)results.get(0)).getName());
        transaction.commit();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-703")
    public void testPolymorphicQueryForUnindexedSuperTypeReturnsIndexedSubType() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Object.class).get();
        Query query = builder.all().createQuery();
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Object.class}).list();
        Assert.assertEquals((String)"expected all instances of all indexed types", (long)10L, (long)results.size());
        transaction.commit();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-703")
    public void testPolymorphicQueryWithKeywordTermForUnindexedSuperTypeReturnsIndexedSubType() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Car.class).get();
        Query query = builder.keyword().onField("name").matching((Object)"Morris").createQuery();
        List results = this.fullTextSession.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"expected one instance of indexed sub-type", (long)1L, (long)results.size());
        Assert.assertEquals((long)180L, (long)((SportsCar)results.get(0)).getEnginePower());
        transaction.commit();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-703")
    public void testObtainingBuilderForUnindexedTypeWithoutIndexedSubTypesCausesException() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        try {
            this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Animal.class).get();
            Assert.fail((String)"Obtaining a builder not allowed for unindexed type without any indexed sub-types.");
        }
        catch (SearchException searchException) {
        }
        finally {
            transaction.commit();
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1791")
    public void testUsingMatchQueryOnNumericDocumentIdGeneratesTermQuery() throws Exception {
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().onField("id").matching((Object)1).createQuery();
        Assert.assertTrue((String)("A string based TermQuery is expected, but got a " + query.getClass()), (boolean)(query instanceof TermQuery));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1791")
    public void testUsingRangeQueryOnNumericDocumentIdGeneratesTermRangeQuery() throws Exception {
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.range().onField("id").from((Object)1).to((Object)3).createQuery();
        Assert.assertTrue((String)("A string based TermQuery is expected, but got a " + query.getClass()), (boolean)(query instanceof TermRangeQuery));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1791")
    public void testUsingMatchingQueryOnNumericFieldCreatesNumericRangeQuery() throws Exception {
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Day.class).get();
        Query query = monthQb.keyword().onField("idNumeric").matching((Object)2).createQuery();
        Assert.assertTrue((String)("A NumericRangeQuery is expected, but got a " + query.getClass()), (boolean)(query instanceof NumericRangeQuery));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1791")
    public void testUseMatchQueryOnEmbeddedNumericIdCreatesTermQuery() throws Exception {
        QueryBuilder coffeeQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Coffee.class).get();
        Query query = coffeeQb.keyword().onField("brand.id").matching((Object)1).createQuery();
        Assert.assertTrue((String)("A TermQuery is expected, but got a " + query.getClass()), (boolean)(query instanceof TermQuery));
    }

    private void outputQueryAndResults(boolean outputLogs, Coffee originalInstance, Query mltQuery, List<Object[]> results) {
        if (outputLogs) {
            StringBuilder builder = new StringBuilder("Initial coffee: ").append(originalInstance).append("\n\n").append("Query: ").append(mltQuery.toString()).append("\n\n").append("Matching coffees").append("\n");
            for (Object[] entry : results) {
                builder.append("    Score: ").append(entry[1]);
                builder.append(" | Coffee: ").append(entry[0]).append("\n");
            }
            log.debug((Object)builder.toString());
        }
    }

    private void indexTestData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        calendar.set(1900, 2, 12, 0, 0, 0);
        calendar.set(14, 0);
        Date january = calendar.getTime();
        this.fullTextSession.persist((Object)new Month("January", 1, "Month of colder and whitening", "Historically colder than any other month in the northern hemisphere", january, 0.231));
        calendar.set(2000, 2, 12, 0, 0, 0);
        this.february = calendar.getTime();
        this.fullTextSession.persist((Object)new Month("February", 2, "Month of snowboarding", "Historically, the month where we make babies while watching the whitening landscape", this.february, 0.435));
        calendar.set(1800, 2, 12, 0, 0, 0);
        Date march = calendar.getTime();
        this.fullTextSession.persist((Object)new Month("March", 3, "Month of fake spring", "Historically, the month in which we actually find time to go snowboarding.", march, 0.435));
        POI poi = new POI(1, "Tour Eiffel", 48.858333, 2.294444, "Monument");
        this.fullTextSession.persist((Object)poi);
        poi = new POI(2, "Bozo", 24.0, 32.0, "Monument");
        this.fullTextSession.persist((Object)poi);
        SportsCar car = new SportsCar(1, "Leyland", 100);
        this.fullTextSession.persist((Object)car);
        car = new SportsCar(2, "Morris", 180);
        this.fullTextSession.persist((Object)car);
        Day day = new Day(1, 1);
        this.fullTextSession.persist((Object)day);
        day = new Day(2, 2);
        this.fullTextSession.persist((Object)day);
        CoffeeBrand brand = new CoffeeBrand();
        brand.setName("Tasty, Inc.");
        this.fullTextSession.persist((Object)brand);
        Coffee coffee = new Coffee();
        coffee.setName("Peruvian Gold");
        coffee.setBrand(brand);
        this.fullTextSession.persist((Object)coffee);
        tx.commit();
        this.fullTextSession.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Month.class, POI.class, Car.class, SportsCar.class, Animal.class, Day.class, CoffeeBrand.class, Coffee.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.model_mapping", MappingFactory.class.getName());
    }

    public static class MappingFactory {
        @Factory
        public SearchMapping build() {
            SearchMapping mapping = new SearchMapping();
            mapping.analyzerDef("stemmer", StandardTokenizerFactory.class).filter(StandardFilterFactory.class).filter(LowerCaseFilterFactory.class).filter(StopFilterFactory.class).filter(SnowballPorterFilterFactory.class).param("language", "English").analyzerDef("ngram", StandardTokenizerFactory.class).filter(StandardFilterFactory.class).filter(LowerCaseFilterFactory.class).filter(StopFilterFactory.class).filter(NGramFilterFactory.class).param("minGramSize", "3").param("maxGramSize", "3");
            return mapping;
        }
    }
}

