/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.impl;

import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.cfg.impl.SearchConfigurationFromHibernateCore;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.hcore.impl.DefaultHibernateSessionFactoryService;
import org.hibernate.search.hcore.impl.SearchFactoryReference;
import org.hibernate.search.jmx.IndexControlMBean;
import org.hibernate.search.jmx.impl.IndexControl;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class HibernateSearchSessionFactoryObserver
implements SessionFactoryObserver {
    private static final Log log;
    private final ConfigurationService configurationService;
    private final ClassLoaderService classLoaderService;
    private final FullTextIndexEventListener listener;
    private final Metadata metadata;
    private String indexControlMBeanName;
    private ExtendedSearchIntegrator extendedIntegrator;

    public HibernateSearchSessionFactoryObserver(Metadata metadata, ConfigurationService configurationService, FullTextIndexEventListener listener, ClassLoaderService classLoaderService) {
        this.metadata = metadata;
        this.configurationService = configurationService;
        this.listener = listener;
        this.classLoaderService = classLoaderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionFactoryCreated(SessionFactory factory) {
        boolean failedBoot = true;
        try {
            Boolean enableJMX;
            SessionFactoryImplementor factoryImplementor = (SessionFactoryImplementor)factory;
            DefaultHibernateSessionFactoryService sessionService = new DefaultHibernateSessionFactoryService(factory);
            if (this.extendedIntegrator == null) {
                SearchIntegrator searchIntegrator = new SearchIntegratorBuilder().configuration((SearchConfiguration)new SearchConfigurationFromHibernateCore(this.metadata, this.configurationService, this.classLoaderService, sessionService)).buildSearchIntegrator();
                this.extendedIntegrator = (ExtendedSearchIntegrator)searchIntegrator.unwrap(ExtendedSearchIntegrator.class);
            }
            if ((enableJMX = (Boolean)this.configurationService.getSetting("hibernate.search.jmx_enabled", StandardConverters.BOOLEAN, (Object)Boolean.FALSE)).booleanValue()) {
                this.indexControlMBeanName = HibernateSearchSessionFactoryObserver.enableIndexControlBean(this.configurationService, this.extendedIntegrator);
            }
            this.listener.initialize(this.extendedIntegrator);
            ((SearchFactoryReference)factoryImplementor.getServiceRegistry().getService(SearchFactoryReference.class)).initialize(this.extendedIntegrator);
            failedBoot = false;
        }
        finally {
            if (failedBoot) {
                factory.close();
            }
        }
    }

    public void sessionFactoryClosed(SessionFactory factory) {
        if (this.extendedIntegrator != null) {
            this.extendedIntegrator.close();
        }
        if (this.indexControlMBeanName != null) {
            JMXRegistrar.unRegisterMBean((String)this.indexControlMBeanName);
        }
    }

    private static String enableIndexControlBean(ConfigurationService configurationService, ExtendedSearchIntegrator extendedIntegrator) {
        if (StringHelper.isEmpty((String)((String)configurationService.getSetting("hibernate.session_factory_name", StandardConverters.STRING)))) {
            log.debug((Object)"In order to bind the IndexControlMBean the Hibernate SessionFactory has to be available via JNDI");
            return null;
        }
        String mbeanNameSuffix = (String)configurationService.getSetting("hibernate.search.jmx_bean_suffix", StandardConverters.STRING);
        String objectName = JMXRegistrar.buildMBeanName((String)"org.hibernate.search.jmx:type=IndexControlMBean", (String)mbeanNameSuffix);
        if (JMXRegistrar.isNameRegistered((String)objectName)) {
            JMXRegistrar.unRegisterMBean((String)objectName);
        }
        IndexControl indexCtrlBean = new IndexControl(configurationService, extendedIntegrator);
        JMXRegistrar.registerMBean((Object)indexCtrlBean, IndexControlMBean.class, (String)objectName);
        return objectName;
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }
}

