/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.lucene.document.Document;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.bridge.BridgeException;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="1045")
public class BridgeConversionErrorTest
extends SearchTestBase {
    @Test
    public void testClassBridgeError() throws Exception {
        ClassBridged classBridged = new ClassBridged();
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)classBridged);
        try {
            tx.commit();
            Assert.fail();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((boolean)(cause instanceof BridgeException));
            String expectedErrorMessage = "Exception while calling bridge#set\n\tclass: org.hibernate.search.test.bridge.BridgeConversionErrorTest$ClassBridged\n\tpath: test";
            Assert.assertEquals((String)"Wrong error message", (Object)expectedErrorMessage, (Object)cause.getMessage());
        }
    }

    @Test
    public void testFieldBridgeError() throws Exception {
        SimpleEntity entity = new SimpleEntity("foo");
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)entity);
        try {
            tx.commit();
            Assert.fail();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((boolean)(cause instanceof BridgeException));
            String expectedErrorMessage = "Exception while calling bridge#set\n\tclass: org.hibernate.search.test.bridge.BridgeConversionErrorTest$SimpleEntity\n\tpath: name";
            Assert.assertEquals((String)"Wrong error message", (Object)expectedErrorMessage, (Object)cause.getMessage());
        }
    }

    @Test
    public void testEmbeddedBridgeError() throws Exception {
        SimpleEntity entity = new SimpleEntity(null);
        EmbeddedEntity embedded = new EmbeddedEntity("foo");
        entity.setEmbedded(embedded);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)entity);
        try {
            tx.commit();
            Assert.fail();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((boolean)(cause instanceof BridgeException));
            String expectedErrorMessage = "Exception while calling bridge#set\n\tclass: org.hibernate.search.test.bridge.BridgeConversionErrorTest$SimpleEntity\n\tpath: embedded.name";
            Assert.assertEquals((String)"Wrong error message", (Object)expectedErrorMessage, (Object)cause.getMessage());
        }
    }

    @Test
    public void testEmbeddedEmbeddedBridgeError() throws Exception {
        SimpleEntity entity = new SimpleEntity(null);
        EmbeddedEntity embedded = new EmbeddedEntity(null);
        entity.setEmbedded(embedded);
        embedded.setEmbeddedEmbedded(new EmbeddedEmbeddedEntity("foo"));
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)entity);
        try {
            tx.commit();
            Assert.fail();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((boolean)(cause instanceof BridgeException));
            String expectedErrorMessage = "Exception while calling bridge#set\n\tclass: org.hibernate.search.test.bridge.BridgeConversionErrorTest$SimpleEntity\n\tpath: embedded.embeddedEmbedded.name";
            Assert.assertEquals((String)"Wrong error message", (Object)expectedErrorMessage, (Object)cause.getMessage());
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{ClassBridged.class, SimpleEntity.class, EmbeddedEntity.class, EmbeddedEmbeddedEntity.class};
    }

    @Entity
    @Table(name="EMBEDDEDTWICEENTITY")
    public static class EmbeddedEmbeddedEntity {
        @Id
        @GeneratedValue
        private long id;
        @Field
        @FieldBridge(impl=ExceptionThrowingBridge.class)
        private String name;

        public EmbeddedEmbeddedEntity(String name) {
            this.name = name;
        }

        public EmbeddedEmbeddedEntity() {
        }
    }

    @Entity
    @Table(name="EMBEDDEDENTITY")
    public static class EmbeddedEntity {
        @Id
        @GeneratedValue
        private long id;
        @Field
        @FieldBridge(impl=ExceptionThrowingBridge.class)
        private String name;
        @IndexedEmbedded
        @OneToOne(cascade={CascadeType.ALL})
        private EmbeddedEmbeddedEntity embeddedEmbedded;

        public EmbeddedEntity(String name) {
            this.name = name;
        }

        public EmbeddedEntity() {
        }

        public void setEmbeddedEmbedded(EmbeddedEmbeddedEntity embedded) {
            this.embeddedEmbedded = embedded;
        }
    }

    @Entity
    @Indexed
    @Table(name="SIMPLEENTITY")
    public static class SimpleEntity {
        @Id
        @GeneratedValue
        private long id;
        @Field
        @FieldBridge(impl=ExceptionThrowingBridge.class)
        private String name;
        @IndexedEmbedded
        @OneToOne(cascade={CascadeType.ALL})
        private EmbeddedEntity embedded;

        public SimpleEntity(String name) {
            this.name = name;
        }

        public SimpleEntity() {
        }

        public void setEmbedded(EmbeddedEntity embedded) {
            this.embedded = embedded;
        }
    }

    @Entity
    @Indexed
    @Table(name="CLASSBRIDGED")
    @ClassBridge(impl=ExceptionThrowingBridge.class, name="test")
    public static class ClassBridged {
        @Id
        @GeneratedValue
        private long id;
    }

    public static class ExceptionThrowingBridge
    implements org.hibernate.search.bridge.FieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            if (value != null) {
                throw new RuntimeException("boom");
            }
        }
    }
}

