/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.fieldAccess;

import java.util.List;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.fieldAccess.Document;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class FieldAccessTest
extends SearchTestBase {
    @Test
    public void testFields() throws Exception {
        Document doc = new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah");
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)doc);
        tx.commit();
        s.clear();
        FullTextSession session = Search.getFullTextSession((Session)s);
        tx = session.beginTransaction();
        QueryParser p = new QueryParser("id", TestConstants.standardAnalyzer);
        List result = session.createFullTextQuery(p.parse("Abstract:Hibernate"), new Class[0]).list();
        Assert.assertEquals((String)"Query by field", (long)1L, (long)result.size());
        s.delete(result.get(0));
        tx.commit();
        s.close();
    }

    @Test
    public void testFieldBoost() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)new Document("Hibernate in Action", "Object and Relational", "blah blah blah"));
        s.persist((Object)new Document("Object and Relational", "Hibernate in Action", "blah blah blah"));
        tx.commit();
        s.clear();
        FullTextSession session = Search.getFullTextSession((Session)s);
        tx = session.beginTransaction();
        QueryParser p = new QueryParser("id", TestConstants.standardAnalyzer);
        List result = session.createFullTextQuery(p.parse("title:Action OR Abstract:Action"), new Class[0]).list();
        Assert.assertEquals((String)"Query by field", (long)2L, (long)result.size());
        Assert.assertEquals((String)"@Boost fails", (Object)"Hibernate in Action", (Object)((Document)result.get(0)).getTitle());
        s.delete(result.get(0));
        tx.commit();
        s.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class};
    }
}

