/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.Date;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;

@Entity
@Indexed
@Table(name="ABT_Entity")
public class ArrayBridgeTestEntity {
    static final String NULL_TOKEN = "NULL_MARKER";
    static final String NULL_NUMERIC_TOKEN = "-555";
    static final String NULL_EMBEDDED = "EMBEDDED_NULL";
    static final String NULL_EMBEDDED_NUMERIC = "-666";
    private Long id;
    private String name;
    private Language[] nullIndexed = new Language[0];
    private String[] nullNotIndexed = new String[0];
    private Integer[] numericNullIndexed = new Integer[0];
    private Long[] numericNullNotIndexed = new Long[0];
    private Date[] dates = new Date[0];

    @Id
    @GeneratedValue
    @Column(name="array_id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="name")
    @Field(store=Store.YES)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Field(indexNullAs="NULL_MARKER", analyze=Analyze.NO)
    @ElementCollection
    @IndexedEmbedded(indexNullAs="EMBEDDED_NULL")
    @OrderColumn
    @CollectionTable(name="NullIndexed", joinColumns={@JoinColumn(name="array_id")})
    @Column(name="nullIndexed")
    public Language[] getNullIndexed() {
        return this.nullIndexed;
    }

    public void setNullIndexed(Language[] nullIndexed) {
        this.nullIndexed = nullIndexed;
    }

    @Field(store=Store.YES, indexNullAs="-555", analyze=Analyze.NO)
    @ElementCollection
    @IndexedEmbedded(prefix="embeddedNum", indexNullAs="-666")
    @OrderColumn
    @CollectionTable(name="NumericNullIndexed", joinColumns={@JoinColumn(name="array_id")})
    @Column(name="numericNullIndexed")
    public Integer[] getNumericNullIndexed() {
        return this.numericNullIndexed;
    }

    public void setNumericNullIndexed(Integer[] phoneNumbers) {
        this.numericNullIndexed = phoneNumbers;
    }

    @Field(store=Store.YES)
    @ElementCollection
    @IndexedEmbedded
    @OrderColumn
    @CollectionTable(name="NullNotIndexed", joinColumns={@JoinColumn(name="array_id")})
    @Column(name="nullNotIndexed")
    public String[] getNullNotIndexed() {
        return this.nullNotIndexed;
    }

    public void setNullNotIndexed(String[] skipNullCollection) {
        this.nullNotIndexed = skipNullCollection;
    }

    @Field(store=Store.YES)
    @ElementCollection
    @IndexedEmbedded
    @OrderColumn
    @CollectionTable(name="NumericNullNotIndexed", joinColumns={@JoinColumn(name="array_id")})
    @Column(name="numericNullNotIndexed")
    public Long[] getNumericNullNotIndexed() {
        return this.numericNullNotIndexed;
    }

    public void setNumericNullNotIndexed(Long[] numericSkipNullCollection) {
        this.numericNullNotIndexed = numericSkipNullCollection;
    }

    @Field(analyze=Analyze.NO, store=Store.YES)
    @ElementCollection
    @IndexedEmbedded
    @DateBridge(resolution=Resolution.SECOND)
    @OrderColumn
    @CollectionTable(name="Dates", joinColumns={@JoinColumn(name="array_id")})
    @Column(name="dates")
    public Date[] getDates() {
        return this.dates;
    }

    public void setDates(Date[] dates) {
        this.dates = dates;
    }

    public String toString() {
        return ArrayBridgeTestEntity.class.getSimpleName() + "[id=" + this.id + ", name=" + this.name + "]";
    }

    public static enum Language {
        ITALIAN,
        ENGLISH,
        PIRATE,
        KLINGON;

    }
}

