/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.test.embedded.fieldoncollection.CollectionOfStringsFieldBridge;
import org.hibernate.search.test.embedded.update.ProductModel;
import org.hibernate.search.test.embedded.update.ProductReferenceCode;
import org.hibernate.search.test.embedded.update.ProductShootingBrief;

@Entity
@Indexed
public class ProductArticle {
    @Id
    @GeneratedValue
    private Long id;
    private String colorCode;
    @ManyToOne(optional=false)
    private ProductModel model;
    @ManyToOne(fetch=FetchType.LAZY)
    @ContainedIn
    private ProductShootingBrief shootingBrief;

    protected ProductArticle() {
    }

    public ProductArticle(ProductModel model, String colorCode) {
        this.model = model;
        this.colorCode = colorCode;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public void setColorCode(String colorCode) {
        this.colorCode = colorCode;
    }

    public ProductModel getModel() {
        return this.model;
    }

    public void setModel(ProductModel model) {
        this.model = model;
    }

    public ProductShootingBrief getShootingBrief() {
        return this.shootingBrief;
    }

    public void setShootingBrief(ProductShootingBrief shootingBrief) {
        if (shootingBrief != null) {
            shootingBrief.getArticles().add(this);
        }
        this.shootingBrief = shootingBrief;
    }

    @Transient
    @Field(bridge=@FieldBridge(impl=CollectionOfStringsFieldBridge.class))
    public Collection<String> getProductReferenceCodeWithColorCollection() {
        ArrayList<String> productReferenceCodeWithColorCollection = new ArrayList<String>();
        productReferenceCodeWithColorCollection.add(this.getProductReferenceCodeWithColor(this.model.getMainReferenceCode()));
        for (ProductReferenceCode code : this.model.getAdditionalReferenceCodes()) {
            productReferenceCodeWithColorCollection.add(this.getProductReferenceCodeWithColor(code));
        }
        return Collections.unmodifiableCollection(productReferenceCodeWithColorCollection);
    }

    @Transient
    @ContainedIn
    private ProductShootingBrief getModelShootingBrief() {
        return this.model.getShootingBrief();
    }

    @Transient
    private String getProductReferenceCodeWithColor(ProductReferenceCode referenceCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(referenceCode.getRawValue());
        sb.append(this.colorCode);
        return sb.toString();
    }
}

