/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.io.Serializable;
import java.util.Collections;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.DefaultInstanceInitializer;
import org.hibernate.search.test.query.facet.Car;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class FacetIndexingFailureTest {
    @Rule
    public SearchFactoryHolder factoryHolder = new SearchFactoryHolder(new Class[]{Car.class});

    @Test
    @TestForIssue(jiraKey="HSEARCH-809")
    @BMRule(targetClass="org.apache.lucene.facet.FacetsConfig", targetMethod="build(Document)", action="throw new IOException(\"Byteman here!\")", name="buildError")
    public void testFailureToIndexFacetThrowsSearchException() throws Exception {
        DocumentBuilderIndexedEntity documentBuilder = this.factoryHolder.extractWorkspace(Car.class).getDocumentBuilder(Car.class);
        try {
            Car car = new Car("Honda", "yellow", 2407);
            documentBuilder.getDocument(null, (Object)car, (Serializable)Integer.valueOf(1), Collections.emptyMap(), DefaultInstanceInitializer.DEFAULT_INITIALIZER, (ConversionContext)new ContextualExceptionBridgeHelper(), null);
            Assert.fail((String)"IOException during facet indexing should throw exception");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000265"));
        }
    }
}

