/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.sorting;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.test.query.sorting.Territory;

@Entity
@Indexed
@ClassBridge(name="fn", impl=FirstAndMiddleNamesFieldBridge.class)
public class Explorer {
    @Id
    private int id;
    @Field
    @SortableField
    private int exploredCountries;
    @Field(bridge=@FieldBridge(impl=LastNameFieldBridge.class))
    @ElementCollection
    private final Map<String, String> nameParts = new HashMap<String, String>();
    @ManyToOne
    @IndexedEmbedded
    @Field(bridge=@FieldBridge(impl=Territory.IdFieldBridge.class))
    @NumericField
    @SortableField
    private Territory favoriteTerritory;

    public Explorer() {
    }

    public Explorer(int id) {
        this.id = id;
    }

    public Explorer(int id, int exploredCountries, Territory favoriteTerritory, String firstName, String middleName, String lastName) {
        this.id = id;
        this.exploredCountries = exploredCountries;
        this.favoriteTerritory = favoriteTerritory;
        this.nameParts.put("firstName", firstName);
        this.nameParts.put("middleName", middleName);
        this.nameParts.put("lastName", lastName);
    }

    public int getId() {
        return this.id;
    }

    public int getExploredCountries() {
        return this.exploredCountries;
    }

    public Map<String, String> getNameParts() {
        return this.nameParts;
    }

    public Territory getFavoriteTerritory() {
        return this.favoriteTerritory;
    }

    public static class LastNameFieldBridge
    implements MetadataProvidingFieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            Map nameParts = (Map)value;
            String lastName = (String)nameParts.get("lastName");
            luceneOptions.addFieldToDocument(name + "_lastName", lastName, document);
            document.add((IndexableField)new SortedDocValuesField(name + "_lastName", new BytesRef((CharSequence)lastName)));
        }

        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(name + "_lastName", FieldType.STRING).sortable(true);
        }
    }

    public static class FirstAndMiddleNamesFieldBridge
    implements MetadataProvidingFieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            Explorer explorer = (Explorer)value;
            String firstName = explorer.getNameParts().get("firstName");
            luceneOptions.addFieldToDocument(name + "_firstName", firstName, document);
            document.add((IndexableField)new SortedDocValuesField(name + "_firstName", new BytesRef((CharSequence)firstName)));
            String middleName = explorer.getNameParts().get("middleName");
            luceneOptions.addFieldToDocument(name + "_middleName", middleName, document);
            document.add((IndexableField)new SortedDocValuesField(name + "_middleName", new BytesRef((CharSequence)middleName)));
        }

        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(name + "_firstName", FieldType.STRING).sortable(true).field(name + "_middleName", FieldType.STRING).sortable(true);
        }
    }
}

