/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.validation;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryValidationTest
extends SearchTestBase {
    private FullTextSession fullTextSession;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Transaction tx = this.openSession().beginTransaction();
        this.getSession().save((Object)new A());
        tx.commit();
        this.getSession().close();
        this.fullTextSession = Search.getFullTextSession((Session)this.openSession());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.fullTextSession.close();
        super.tearDown();
    }

    @Test
    public void testTargetStringEncodedFieldWithNumericRangeQueryThrowsException() {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)"value", (Object)1, (Object)1, (boolean)true, (boolean)true);
        FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{A.class});
        try {
            fullTextQuery.list();
            Assert.fail();
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000232"));
        }
    }

    @Test
    public void testTargetNumericEncodedFieldWithStringQueryThrowsException() {
        TermQuery query = new TermQuery(new Term("value", "bar"));
        FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery((Query)query, new Class[]{B.class});
        try {
            fullTextQuery.list();
            Assert.fail();
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000233"));
        }
    }

    @Test
    public void testTargetingNonIndexedEntityThrowsException() {
        TermQuery query = new TermQuery(new Term("foo", "bar"));
        try {
            this.fullTextSession.createFullTextQuery((Query)query, new Class[]{C.class});
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000234"));
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{A.class, B.class};
    }

    @Entity
    public static class C {
        @Id
        @GeneratedValue
        private long id;
    }

    @Entity
    @Indexed
    public static class B {
        @Id
        @GeneratedValue
        private long id;
        @Field
        private long value;
    }

    @Entity
    @Indexed
    public static class A {
        @Id
        @GeneratedValue
        private long id;
        @Field
        private String value;
    }
}

