/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.definition;

import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Version;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.analyzer.definition.Team;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AnalyzerBuilderIndexingTest
extends SearchTestBase {
    private final String analyzerName;
    private final String stringToIndex;
    private final String[] expectedTokens;
    private final String[] unexpectedTokens;

    @Parameterized.Parameters(name="Analyzer {0}, terms {1}")
    public static Object[][] data() {
        return new Object[][]{{"customanalyzer", "This is a D\u00e0scription", new String[]{"dascript"}, new String[]{"D\u00e0scription", "dascription", "is"}}, {"stemmer_override_analyzer", "This is a D\u00e0scription", new String[]{"dascription"}, new String[]{"D\u00e0scription", "dascript"}}, {"standard_analyzer", "This is just FOOBAR's", new String[]{"This", "is", "just", "FOOBAR's"}, new String[]{"FOOBAR"}}, {"html_standard_analyzer", "This is <b>foo</b><i>bar's</i>", new String[]{"This", "is", "foobar's"}, new String[]{"<b>", "b"}}, {"html_whitespace_analyzer", "This is <b>foo</b><i>bar's</i>", new String[]{"This", "is", "foobar's"}, new String[]{"<b>", "b"}}, {"trim_analyzer", " Kittens!   ", new String[]{"Kittens!"}, new String[]{" Kittens!   "}}, {"length_analyzer", "ab abc abcd abcde abcdef", new String[]{"abc", "abcd", "abcde"}, new String[]{"ab", "abcdef"}}, {"porter_analyzer", "bikes", new String[]{"bike"}, new String[]{"bikes"}}, {"porter_analyzer", "biking", new String[]{"bike"}, new String[]{"biking"}}, {"word_analyzer", "CamelCase", new String[]{"Camel", "Case"}, new String[]{"CamelCase"}}, {"synonym_analyzer", "ipod cosmos", new String[]{"ipod", "universe"}, new String[]{"cosmos"}}, {"shingle_analyzer", "please divide this sentence into shingles", new String[]{"please", "please divide", "divide", "divide this", "this", "this sentence", "sentence", "sentence into", "into", "into shingles", "shingles"}, new String[]{"please divide this"}}, {"pattern_analyzer", "foo,bar", new String[]{"foo", "bar"}, new String[]{"foo,bar"}}, {"mapping_char_analyzer", "CORA\u00c7\u00c3O DE MEL\u00c3O", new String[]{"CORACAO", "DE", "MELAO"}, new String[]{"CORA\u00c7\u00c3O"}}};
    }

    public AnalyzerBuilderIndexingTest(String analyzerName, String stringToIndex, String[] expectedTokens, String[] unexpectedTokens) {
        this.analyzerName = analyzerName;
        this.stringToIndex = stringToIndex;
        this.expectedTokens = expectedTokens;
        this.unexpectedTokens = unexpectedTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        Team team = new Team();
        team.setName(this.stringToIndex);
        FullTextSession fts = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fts.beginTransaction();
        try {
            fts.persist((Object)team);
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        tx.commit();
        try {
            TermQuery query;
            String fieldName;
            if (this.unexpectedTokens != null) {
                for (String token : this.unexpectedTokens) {
                    fieldName = "name_" + this.analyzerName;
                    query = new TermQuery(new Term(fieldName, token));
                    ((ListAssert)Assertions.assertThat((List)fts.createFullTextQuery((Query)query, new Class[0]).list()).as("Results of searching '" + token + "' on field '" + fieldName + "'")).isEmpty();
                }
            }
            for (String token : this.expectedTokens) {
                fieldName = "name_" + this.analyzerName;
                query = new TermQuery(new Term(fieldName, token));
                ((ListAssert)Assertions.assertThat((List)fts.createFullTextQuery((Query)query, new Class[0]).list()).as("Results of searching '" + token + "' on field '" + fieldName + "'")).containsOnly(new Object[]{team});
            }
        }
        finally {
            tx = fts.beginTransaction();
            try {
                fts.delete((Object)team);
            }
            catch (Exception e) {
                tx.rollback();
                throw e;
            }
        }
        fts.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Team.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        super.configure(cfg);
        cfg.put("hibernate.search.lucene_version", Version.LATEST.toString());
    }
}

