/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.inheritance;

import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.analyzer.AnalyzerTest;
import org.hibernate.search.test.analyzer.inheritance.SubClass;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.util.AnalyzerUtils;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class AnalyzerInheritanceTest
extends SearchTestBase {
    public static final Log log = LoggerFactory.make();

    @Test
    public void testBySearch() throws Exception {
        SubClass testClass = new SubClass();
        testClass.setName("I\u0307stanbul");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)testClass);
        tx.commit();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("name", TestConstants.keywordAnalyzer);
        Query luceneQuery = parser.parse("name:istanbul");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[]{SubClass.class});
        Assert.assertEquals((long)1L, (long)query.getResultSize());
        luceneQuery = parser.parse("name:foo");
        query = s.createFullTextQuery(luceneQuery, new Class[]{SubClass.class});
        Assert.assertEquals((long)0L, (long)query.getResultSize());
        tx.commit();
        s.close();
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testByAnalyzerRetrieval() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Analyzer analyzer = s.getSearchFactory().getAnalyzer(SubClass.class);
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)"I\u0307stanbul");
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"istanbul"});
        s.close();
    }

    @Override
    public void configure(Map<String, Object> settings) {
        super.configure(settings);
        settings.put("hibernate.search.analyzer", KeywordAnalyzer.class.getName());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{SubClass.class};
    }
}

