/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.Date;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.bridge.ArrayBridgeTestEntity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ArrayBridgeTest
extends SearchTestBase {
    private FullTextSession fullTextSession;
    private ArrayBridgeTestEntity withoutNull;
    private ArrayBridgeTestEntity withNullEntry;
    private ArrayBridgeTestEntity withNullEmbedded;
    private Date indexedDate;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.prepareData();
    }

    private void prepareData() {
        this.indexedDate = new Date();
        Transaction tx = this.fullTextSession.beginTransaction();
        this.withoutNull = this.persistEntity((Session)this.fullTextSession, "Davide D'Alto");
        this.withoutNull.setNullIndexed(new ArrayBridgeTestEntity.Language[]{ArrayBridgeTestEntity.Language.ITALIAN, ArrayBridgeTestEntity.Language.ENGLISH});
        this.withoutNull.setNumericNullIndexed(new Integer[]{1, 2});
        this.withoutNull.setNullNotIndexed(new String[]{"DaltoValue", "DavideValue"});
        this.withoutNull.setNumericNullNotIndexed(new Long[]{3L, 4L});
        this.withoutNull.setDates(new Date[]{this.indexedDate});
        this.withNullEntry = this.persistEntity((Session)this.fullTextSession, "Worf");
        this.withNullEntry.setNullIndexed(new ArrayBridgeTestEntity.Language[]{ArrayBridgeTestEntity.Language.KLINGON, ArrayBridgeTestEntity.Language.ENGLISH, null});
        this.withNullEntry.setNumericNullIndexed(new Integer[]{11, null});
        this.withNullEntry.setNullNotIndexed(new String[]{"WorfValue", null});
        this.withNullEntry.setNumericNullNotIndexed(new Long[]{33L, null});
        this.withNullEntry.setDates(new Date[]{null});
        this.withNullEmbedded = this.persistEntity((Session)this.fullTextSession, "Mime");
        this.withNullEmbedded.setDates(null);
        this.withNullEmbedded.setNumericNullIndexed(null);
        this.withNullEmbedded.setNumericNullNotIndexed(null);
        this.withNullEmbedded.setNullIndexed(null);
        this.withNullEmbedded.setNullNotIndexed(null);
        this.withNullEmbedded.setDates(null);
        tx.commit();
    }

    @Test
    public void testSearchNullEntry() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findResults("nullIndexed", "NULL_MARKER", true);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Unexpected number of results in a collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned looking for a null in a collection", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNullNumericEntry() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findResults("numericNullIndexed", "-555", true);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Unexpected number of results in a collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned looking for a null in a collection of numeric", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNotNullEntry() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findResults("nullIndexed", (Object)ArrayBridgeTestEntity.Language.KLINGON, false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)ArrayBridgeTestEntity.Language.ITALIAN, false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)ArrayBridgeTestEntity.Language.ENGLISH, false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)2L, (long)results.size());
    }

    @Test
    public void testSearchEntryWhenNullEntryNotIndexed() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findResults("nullNotIndexed", "DaltoValue", false);
        Assert.assertNotNull((String)"No result found for an indexed array", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed array", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed array", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findResults("nullNotIndexed", "WorfValue", false);
        Assert.assertNotNull((String)"No result found for an indexed array", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed array", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed array", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNotNullNumeric() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findNumericResults("numericNullIndexed", 1);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findNumericResults("numericNullIndexed", 11);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNotNullNumericEntryWhenNullEntryNotIndexed() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findNumericResults("numericNullNotIndexed", 3L);
        Assert.assertNotNull((String)"No result found for an indexed array", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed array", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed array", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findNumericResults("numericNullNotIndexed", 33L);
        Assert.assertNotNull((String)"No result found for an indexed array", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed array", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed array", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testDateIndexing() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findResultsWithRangeQuery("dates", DateTools.round((Date)this.indexedDate, (DateTools.Resolution)DateTools.Resolution.SECOND));
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from a collection of Date", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
    }

    private List<ArrayBridgeTestEntity> findResults(String fieldName, Object value, boolean checkNullToken) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ArrayBridgeTestEntity.class).get();
        TermMatchingContext termMatchingContext = queryBuilder.keyword().onField(fieldName);
        if (checkNullToken) {
            termMatchingContext.ignoreFieldBridge();
            termMatchingContext.ignoreAnalyzer();
        }
        Query query = termMatchingContext.matching(value).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{ArrayBridgeTestEntity.class}).list();
    }

    private List<ArrayBridgeTestEntity> findResultsWithRangeQuery(String fieldName, Object start) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ArrayBridgeTestEntity.class).get();
        Query query = queryBuilder.range().onField(fieldName).above(start).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{ArrayBridgeTestEntity.class}).list();
    }

    private List<ArrayBridgeTestEntity> findNumericResults(String fieldName, Object number) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)number, (Object)number, (boolean)true, (boolean)true);
        return this.fullTextSession.createFullTextQuery(query, new Class[]{ArrayBridgeTestEntity.class}).list();
    }

    private ArrayBridgeTestEntity persistEntity(Session s, String name) {
        ArrayBridgeTestEntity boy = new ArrayBridgeTestEntity();
        boy.setName(name);
        s.persist((Object)boy);
        return boy;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{ArrayBridgeTestEntity.class};
    }
}

