/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import org.fest.assertions.Assertions;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.directoryProvider.CloseCheckingDirectoryProvider;
import org.hibernate.search.test.directoryProvider.SnowStorm;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class DirectoryLifecycleTest {
    @Test
    public void testLifecycle() {
        this.testOnce();
        this.testOnce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testOnce() {
        CloseCheckingDirectoryProvider directoryProvider;
        try (FullTextSessionBuilder builder = new FullTextSessionBuilder().setProperty("hibernate.search.default.directory_provider", CloseCheckingDirectoryProvider.class.getName()).addAnnotatedClass(SnowStorm.class).build();){
            SearchIntegrator integrator = (SearchIntegrator)builder.getSearchFactory().unwrap(SearchIntegrator.class);
            EntityIndexBinding snowIndexBinder = integrator.getIndexBinding(SnowStorm.class);
            IndexManager[] indexManagers = snowIndexBinder.getIndexManagers();
            Assertions.assertThat((int)indexManagers.length).isEqualTo(1);
            Assertions.assertThat((Object)indexManagers[0]).isInstanceOf(DirectoryBasedIndexManager.class);
            DirectoryBasedIndexManager dbBasedManager = (DirectoryBasedIndexManager)indexManagers[0];
            Assertions.assertThat((Object)dbBasedManager.getDirectoryProvider()).isInstanceOf(CloseCheckingDirectoryProvider.class);
            directoryProvider = (CloseCheckingDirectoryProvider)dbBasedManager.getDirectoryProvider();
            Assertions.assertThat((boolean)directoryProvider.isInitialized()).isTrue();
            Assertions.assertThat((boolean)directoryProvider.isStarted()).isTrue();
            Assertions.assertThat((boolean)directoryProvider.isStopped()).isFalse();
        }
        Assertions.assertThat((boolean)directoryProvider.isStopped()).isTrue();
    }
}

