/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.Search;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.id.PersonCustomDocumentId;
import org.hibernate.search.test.id.PersonPK;
import org.hibernate.search.testsupport.backend.LeakingLocalBackend;
import org.junit.Assert;
import org.junit.Test;

public class EmbeddedIdWithDocumentIdTest
extends SearchTestBase {
    @Test
    public void testFieldBridge() throws Exception {
        LeakingLocalBackend.reset();
        PersonPK johnDoePk = new PersonPK();
        johnDoePk.setFirstName("John");
        johnDoePk.setLastName("Doe");
        PersonCustomDocumentId johnDoe = new PersonCustomDocumentId();
        johnDoe.setFavoriteColor("Blue");
        johnDoe.setPersonNames(johnDoePk);
        johnDoe.setSecurityNumber("AB123");
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.save((Object)johnDoe);
        tx.commit();
        s.clear();
        List lastProcessedQueue = LeakingLocalBackend.getLastProcessedQueue();
        Assert.assertEquals((long)1L, (long)lastProcessedQueue.size());
        LuceneWork luceneWork = (LuceneWork)lastProcessedQueue.get(0);
        Assert.assertEquals((Object)"AB123", (Object)luceneWork.getIdInString());
        tx = s.beginTransaction();
        QueryBuilder queryBuilder = this.getSearchFactory().buildQueryBuilder().forEntity(PersonCustomDocumentId.class).get();
        Query query = ((TermMatchingContext)queryBuilder.keyword().onField("id").ignoreAnalyzer()).matching((Object)"AB123").createQuery();
        List results = Search.getFullTextSession((Session)s).createFullTextQuery(query, new Class[]{PersonCustomDocumentId.class}).list();
        Assert.assertEquals((long)1L, (long)results.size());
        johnDoe = (PersonCustomDocumentId)results.get(0);
        johnDoe.setFavoriteColor("Red");
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        results = Search.getFullTextSession((Session)s).createFullTextQuery(query, new Class[]{PersonCustomDocumentId.class}).list();
        Assert.assertEquals((long)1L, (long)results.size());
        johnDoe = (PersonCustomDocumentId)results.get(0);
        Assert.assertEquals((Object)"Red", (Object)johnDoe.getFavoriteColor());
        s.delete(results.get(0));
        tx.commit();
        s.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{PersonCustomDocumentId.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.worker.backend", LeakingLocalBackend.class.getName());
    }
}

