/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import java.io.Serializable;
import java.util.Properties;
import org.apache.lucene.document.Document;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.IndexShardingStrategy;

public class CustomerShardingStrategy
implements IndexShardingStrategy {
    private IndexManager[] indexManagers;

    public void initialize(Properties properties, IndexManager[] indexManagers) {
        this.indexManagers = indexManagers;
    }

    public IndexManager[] getIndexManagersForAllShards() {
        return this.indexManagers;
    }

    public IndexManager getIndexManagerForAddition(Class<?> entity, Serializable id, String idInString, Document document) {
        String stringValueId = document.getField("customerID").stringValue();
        Integer customerID = Integer.parseInt(stringValueId);
        return this.indexManagers[customerID];
    }

    public IndexManager[] getIndexManagersForDeletion(Class<?> entity, Serializable id, String idInString) {
        return this.getIndexManagersForAllShards();
    }

    public IndexManager[] getIndexManagersForQuery(FullTextFilterImplementor[] filters) {
        FullTextFilter filter = this.getCustomerFilter(filters, "customer");
        if (filter == null) {
            return this.getIndexManagersForAllShards();
        }
        return new IndexManager[]{this.indexManagers[Integer.parseInt(filter.getParameter("customerID").toString())]};
    }

    private FullTextFilter getCustomerFilter(FullTextFilterImplementor[] filters, String name) {
        for (FullTextFilterImplementor filter : filters) {
            if (!filter.getName().equals(name)) continue;
            return filter;
        }
        return null;
    }
}

