/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.tika;

import java.net.URI;
import java.sql.Blob;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.TikaBridge;

@Entity
@Indexed
public class Book {
    private Integer id;
    private Blob contentAsBlob;
    private byte[] contentAsBytes;
    private URI contentAsURI;
    private Set<String> contentAsListOfString;

    public Book() {
    }

    public Book(String ... contents) {
        HashSet<String> temp = new HashSet<String>();
        for (String string : contents) {
            temp.add(string);
        }
        this.contentAsListOfString = temp;
    }

    public Book(Blob content) {
        this.contentAsBlob = content;
    }

    public Book(byte[] content) {
        this.contentAsBytes = content;
    }

    public Book(URI content) {
        this.contentAsURI = content;
    }

    @Id
    @GeneratedValue
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Field(indexNullAs="<NULL>")
    @TikaBridge
    public Blob getContentAsBlob() {
        return this.contentAsBlob;
    }

    public void setContentAsBlob(Blob contentAsBlob) {
        this.contentAsBlob = contentAsBlob;
    }

    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Field(indexNullAs="<NULL>")
    @TikaBridge
    public byte[] getContentAsBytes() {
        return this.contentAsBytes;
    }

    public void setContentAsBytes(byte[] contentAsBytes) {
        this.contentAsBytes = contentAsBytes;
    }

    @Basic(fetch=FetchType.LAZY)
    @Field(indexNullAs="<NULL>")
    @TikaBridge
    public URI getContentAsURI() {
        return this.contentAsURI;
    }

    public void setContentAsURI(URI contentAsURI) {
        this.contentAsURI = contentAsURI;
    }

    @IndexedEmbedded
    @Field
    @TikaBridge
    @ElementCollection
    public Set<String> getContentAsListOfString() {
        return this.contentAsListOfString;
    }

    public void setContentAsListOfString(Set<String> contentAsListOfString) {
        this.contentAsListOfString = contentAsListOfString;
    }
}

