/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.optimizations.mappedsuperclasscollection;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.engine.optimizations.mappedsuperclasscollection.EntityExtendingMappedSuperclassWithCollectionField;
import org.hibernate.search.test.engine.optimizations.mappedsuperclasscollection.MappedSuperclassWithCollectionField;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1583")
public class InheritedCollectionFieldCollectionUpdateEventTest
extends SearchTestBase {
    private static final String FIRST_COLLECTION_VALUE = "1";
    private static final String SECOND_COLLECTION_VALUE = "2";
    private FullTextSession fullTextSession;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.fullTextSession.close();
        super.tearDown();
    }

    @Test
    public void testUpdateOfCollectionInMappedSuperclass() {
        EntityExtendingMappedSuperclassWithCollectionField entity = new EntityExtendingMappedSuperclassWithCollectionField();
        this.addToCollectionAndPersist(entity, FIRST_COLLECTION_VALUE);
        Assert.assertEquals((String)"First collection value is persisted and should be indexed", (long)1L, (long)this.searchEntityByCollectionValue(FIRST_COLLECTION_VALUE).size());
        Assert.assertEquals((String)"Second collection value is not yet added and should not be indexed", (long)0L, (long)this.searchEntityByCollectionValue(SECOND_COLLECTION_VALUE).size());
        this.fullTextSession.clear();
        entity = (EntityExtendingMappedSuperclassWithCollectionField)this.fullTextSession.get(EntityExtendingMappedSuperclassWithCollectionField.class, (Serializable)entity.getId());
        this.addToCollectionAndPersist(entity, SECOND_COLLECTION_VALUE);
        Assert.assertEquals((String)"Second collection value is persisted and should be indexed", (long)1L, (long)this.searchEntityByCollectionValue(SECOND_COLLECTION_VALUE).size());
    }

    private void addToCollectionAndPersist(EntityExtendingMappedSuperclassWithCollectionField entity, String value) {
        Transaction transaction = this.fullTextSession.beginTransaction();
        entity.getCollection().add(value);
        this.fullTextSession.persist((Object)entity);
        transaction.commit();
        this.fullTextSession.clear();
    }

    private List<EntityExtendingMappedSuperclassWithCollectionField> searchEntityByCollectionValue(String value) {
        Transaction transaction = this.fullTextSession.beginTransaction();
        FullTextQuery query = this.fullTextSession.createFullTextQuery((Query)new TermQuery(new Term("collection", value)), new Class[]{EntityExtendingMappedSuperclassWithCollectionField.class});
        List result = query.list();
        transaction.commit();
        this.fullTextSession.clear();
        return result;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{MappedSuperclassWithCollectionField.class, EntityExtendingMappedSuperclassWithCollectionField.class};
    }
}

