/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.testing.boot.JdbcConnectionAccessImpl;
import org.hibernate.testing.env.ConnectionProviderBuilder;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.SchemaCreatorImpl;
import org.hibernate.tool.schema.internal.SchemaDropperImpl;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.internal.exec.GenerationTargetToDatabase;
import org.hibernate.tool.schema.internal.exec.JdbcConnectionContext;
import org.hibernate.tool.schema.internal.exec.JdbcConnectionContextNonSharedImpl;

public class MultitenancyTestHelper
implements Closeable {
    private final Set<String> tenantIds;
    private final boolean multitenancyEnabled;
    private final AbstractMultiTenantConnectionProvider multiTenantConnectionProvider;
    private final Map<String, DriverManagerConnectionProviderImpl> tenantSpecificConnectionProviders = new HashMap<String, DriverManagerConnectionProviderImpl>();

    public MultitenancyTestHelper(Set<String> tenantIds) {
        this.tenantIds = tenantIds;
        this.multitenancyEnabled = tenantIds != null && tenantIds.size() != 0;
        this.multiTenantConnectionProvider = this.multitenancyEnabled ? this.buildMultiTenantConnectionProvider() : null;
    }

    public void enableIfNeeded(StandardServiceRegistryBuilder registryBuilder) {
        registryBuilder.addService(MultiTenantConnectionProvider.class, (Service)this.multiTenantConnectionProvider);
    }

    private AbstractMultiTenantConnectionProvider buildMultiTenantConnectionProvider() {
        for (String tenantId : this.tenantIds) {
            DriverManagerConnectionProviderImpl connectionProvider = ConnectionProviderBuilder.buildConnectionProvider((String)tenantId);
            this.tenantSpecificConnectionProviders.put(tenantId, connectionProvider);
        }
        return new AbstractMultiTenantConnectionProvider(){

            protected ConnectionProvider getAnyConnectionProvider() {
                return (ConnectionProvider)MultitenancyTestHelper.this.tenantSpecificConnectionProviders.entrySet().iterator().next().getValue();
            }

            protected ConnectionProvider selectConnectionProvider(String tenantIdentifier) {
                DriverManagerConnectionProviderImpl connectionProviderImpl = (DriverManagerConnectionProviderImpl)MultitenancyTestHelper.this.tenantSpecificConnectionProviders.get(tenantIdentifier);
                if (connectionProviderImpl == null) {
                    throw new HibernateException("Unknown tenant identifier");
                }
                return connectionProviderImpl;
            }
        };
    }

    @Override
    public void close() {
        for (DriverManagerConnectionProviderImpl connectionProvider : this.tenantSpecificConnectionProviders.values()) {
            connectionProvider.stop();
        }
    }

    public void exportSchema(ServiceRegistryImplementor serviceRegistry, Metadata metadata, Map<String, Object> settings) {
        HibernateSchemaManagementTool tool = new HibernateSchemaManagementTool();
        tool.injectServices(serviceRegistry);
        GenerationTargetToDatabase[] databaseTargets = this.createSchemaTargets();
        new SchemaDropperImpl((ServiceRegistry)serviceRegistry).doDrop(metadata, (ServiceRegistry)serviceRegistry, settings, true, (GenerationTarget[])databaseTargets);
        new SchemaCreatorImpl((ServiceRegistry)serviceRegistry).doCreation(metadata, (ServiceRegistry)serviceRegistry, settings, true, (GenerationTarget[])databaseTargets);
    }

    private GenerationTargetToDatabase[] createSchemaTargets() {
        GenerationTargetToDatabase[] targets = new GenerationTargetToDatabase[this.tenantSpecificConnectionProviders.size()];
        int index = 0;
        for (Map.Entry<String, DriverManagerConnectionProviderImpl> e : this.tenantSpecificConnectionProviders.entrySet()) {
            ConnectionProvider connectionProvider = (ConnectionProvider)e.getValue();
            targets[index] = new GenerationTargetToDatabase((JdbcConnectionContext)new JdbcConnectionContextNonSharedImpl((JdbcConnectionAccess)new JdbcConnectionAccessImpl(connectionProvider), new SqlStatementLogger(false, false), true));
            ++index;
        }
        return targets;
    }

    public void forceConfigurationSettings(Map<String, Object> settings) {
        if (this.multitenancyEnabled) {
            settings.remove("hibernate.hbm2ddl.auto");
            settings.put("hibernate.multiTenancy", MultiTenancyStrategy.DATABASE.name());
        }
    }
}

