/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.nullValues;

import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.ProjectionToMapResultTransformer;
import org.hibernate.search.test.query.nullValues.Value;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.transform.ResultTransformer;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-115")
public class IndexAndQueryNullTest
extends SearchTestBase {
    @Test
    public void testIndexAndSearchNull() throws Exception {
        Value fooValue = new Value("foo");
        Value nullValue = new Value(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.getSession().save((Object)fooValue);
        this.getSession().save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        this.searchKeywordWithExpectedNumberOfResults(fullTextSession, "value", "foo", 1);
        this.searchKeywordWithExpectedNumberOfResults(fullTextSession, "value", "_custom_token_", 1);
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testNullIndexingWithDSLQuery() throws Exception {
        Value fooValue = new Value("foo");
        Value nullValue = new Value(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.getSession().save((Object)fooValue);
        this.getSession().save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        QueryBuilder queryBuilder = this.getSearchFactory().buildQueryBuilder().forEntity(Value.class).get();
        Query query = queryBuilder.keyword().onField("value").matching(null).createQuery();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Value.class});
        List valueList = fullTextQuery.list();
        Assert.assertEquals((String)"Wrong number of results", (long)1L, (long)valueList.size());
        tx.commit();
        fullTextSession.close();
    }

    @Test(expected=SearchException.class)
    public void testNullIndexingWithDSLQueryIgnoringFieldBridge() throws Exception {
        QueryBuilder queryBuilder = this.getSearchFactory().buildQueryBuilder().forEntity(Value.class).get();
        ((TermMatchingContext)queryBuilder.keyword().onField("value").ignoreFieldBridge()).matching(null).createQuery();
    }

    @Test
    public void testProjectedValueGetsConvertedToNull() throws Exception {
        Value nullValue = new Value(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.getSession().save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{Value.class});
        fullTextQuery.setProjection(new String[]{"id", "value"});
        fullTextQuery.setResultTransformer((ResultTransformer)new ProjectionToMapResultTransformer());
        List mappedResults = fullTextQuery.list();
        Assert.assertTrue((String)"Wrong result size", (mappedResults.size() == 1 ? 1 : 0) != 0);
        Map map = (Map)mappedResults.get(0);
        Integer id = (Integer)map.get("id");
        Assert.assertNotNull((Object)id);
        String value = (String)map.get("value");
        Assert.assertEquals((String)"The null token should be converted back to null", null, (Object)value);
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testIndexAndSearchConfiguredDefaultNullToken() throws Exception {
        Value fooValue = new Value("foo");
        fooValue.setFallback("foo");
        Value nullValue = new Value("bar");
        nullValue.setFallback(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.getSession().save((Object)fooValue);
        this.getSession().save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        this.searchKeywordWithExpectedNumberOfResults(fullTextSession, "fallback", "foo", 1);
        this.searchKeywordWithExpectedNumberOfResults(fullTextSession, "fallback", "fubar", 1);
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testIndexAndSearchWithCustomFieldBridge() throws Exception {
        Value fooValue = new Value("foo");
        fooValue.setDummy("foo");
        Value nullValue = new Value("bar");
        nullValue.setDummy(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.getSession().save((Object)fooValue);
        this.getSession().save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        this.searchKeywordWithExpectedNumberOfResults(fullTextSession, "dummy", "foo", 1);
        this.searchKeywordWithExpectedNumberOfResults(fullTextSession, "dummy", "_dummy_", 1);
        tx.commit();
        fullTextSession.close();
    }

    private void searchKeywordWithExpectedNumberOfResults(FullTextSession fullTextSession, String fieldName, String termValue, int expectedNumberOfResults) throws Exception {
        TermQuery query = new TermQuery(new Term(fieldName, termValue));
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{Value.class});
        List valueList = fullTextQuery.list();
        Assert.assertEquals((String)"Wrong number of results", (long)expectedNumberOfResults, (long)valueList.size());
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default_null_token", "fubar");
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Value.class};
    }

    static enum QueryType {
        USE_LUCENE_QUERY,
        USE_DSL_QUERY;

    }
}

