/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class CustomAnalyzerDefinitionInClassBridgeTest
extends SearchTestBase {
    public static final Log log = LoggerFactory.make();

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{FooBar.class};
    }

    @Test
    public void testClassBridgeWithSingleField() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.persist((Object)new FooBar());
        tx.commit();
        fullTextSession.clear();
        TermQuery termQuery = new TermQuery(new Term("classField", "dog"));
        FullTextQuery query = fullTextSession.createFullTextQuery((Query)termQuery, new Class[0]);
        Assert.assertEquals((String)"custom analyzer should have inserted search token", (long)1L, (long)query.getResultSize());
        fullTextSession.close();
    }

    public static class FooBarBridge
    implements FieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            luceneOptions.addFieldToDocument(name, "alarm Dog performance", document);
        }
    }

    @Entity
    @Table(name="JUSTFOOBAR")
    @Indexed
    @AnalyzerDef(name="foobarAnalyzer", tokenizer=@TokenizerDef(factory=WhitespaceTokenizerFactory.class), filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class)})
    @ClassBridge(name="classField", impl=FooBarBridge.class, analyzer=@Analyzer(definition="foobarAnalyzer"))
    public static class FooBar {
        @Id
        @GeneratedValue
        private Integer id;
    }
}

