/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.integration;

import org.hibernate.event.service.internal.EventListenerRegistryImpl;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.hcore.impl.HibernateSearchIntegrator;
import org.junit.Assert;
import org.junit.Test;

public class DuplicationStrategyTest {
    @Test
    public void testMultipleRegistrationOfEventListenerKeepsOriginalListener() {
        EventListenerRegistryImpl eventListenerRegistry = new EventListenerRegistryImpl();
        EventListenerGroup eventEventListenerGroup = eventListenerRegistry.getEventListenerGroup(EventType.POST_INSERT);
        Assert.assertTrue((String)"We should start of with no listeners", (eventEventListenerGroup.count() == 0 ? 1 : 0) != 0);
        FullTextIndexEventListener firstFullTextIndexEventListener = new FullTextIndexEventListener();
        eventListenerRegistry.setListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{firstFullTextIndexEventListener});
        eventListenerRegistry.addDuplicationStrategy((DuplicationStrategy)new HibernateSearchIntegrator.DuplicationStrategyImpl(FullTextIndexEventListener.class));
        eventListenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{new FullTextIndexEventListener()});
        Assert.assertTrue((String)("We should only be one listener, but we have " + eventEventListenerGroup.count()), (eventEventListenerGroup.count() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The instances should match", (firstFullTextIndexEventListener == eventEventListenerGroup.listeners().iterator().next() ? 1 : 0) != 0);
    }
}

