/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.initandlookup;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.testsupport.BytemanHelper;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@TestForIssue(jiraKey="HSEARCH-1119")
@RunWith(value=BMUnitRunner.class)
@Category(value={ElasticsearchSupportInProgress.class})
public class ObjectLookupAndDatabaseRetrievalConfigurationTest {
    @Rule
    public BytemanHelper.BytemanAccessor byteman = BytemanHelper.createAccessor();

    @Test
    @BMRule(targetClass="org.hibernate.search.query.hibernate.impl.CriteriaObjectInitializer", targetMethod="initializeObjects(java.util.List, java.util.LinkedHashMap, org.hibernate.search.query.hibernate.impl.ObjectInitializationContext)", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()", name="testSetLookupMethodPersistenceContext")
    public void testDefaultLookupMethod() throws Exception {
        try (FullTextSessionBuilder builder = this.buildFullTextSessionBuilder(null, null);){
            this.indexTestData(builder);
            FullTextSession fullTextSession = builder.openFullTextSession();
            Transaction tx = fullTextSession.beginTransaction();
            FullTextQuery query = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
            query.list();
            tx.commit();
            fullTextSession.close();
            Assert.assertEquals((String)"CriteriaObjectInitializer should have been used as object initializer", (long)1L, (long)this.byteman.getAndResetInvocationCount());
        }
    }

    @Test
    @BMRule(targetClass="org.hibernate.search.query.hibernate.impl.PersistenceContextObjectInitializer", targetMethod="initializeObjects(java.util.List, java.util.LinkedHashMap, org.hibernate.search.query.hibernate.impl.ObjectInitializationContext)", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()", name="testSetLookupMethodPersistenceContext")
    public void testSetLookupMethodPersistenceContextUpperCase() throws Exception {
        try (FullTextSessionBuilder builder = this.buildFullTextSessionBuilder("PERSISTENCE_CONTEXT", null);){
            this.indexTestData(builder);
            FullTextSession fullTextSession = builder.openFullTextSession();
            Transaction tx = fullTextSession.beginTransaction();
            FullTextQuery query = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
            query.list();
            tx.commit();
            fullTextSession.close();
            Assert.assertEquals((String)"PersistenceContextObjectInitializer should have been used as object initializer", (long)1L, (long)this.byteman.getAndResetInvocationCount());
        }
    }

    @Test
    @BMRule(targetClass="org.hibernate.search.query.hibernate.impl.PersistenceContextObjectInitializer", targetMethod="initializeObjects(java.util.List, java.util.LinkedHashMap, org.hibernate.search.query.hibernate.impl.ObjectInitializationContext)", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()", name="testSetLookupMethodPersistenceContext")
    public void testSetLookupMethodPersistenceContextLowerCase() throws Exception {
        try (FullTextSessionBuilder builder = this.buildFullTextSessionBuilder("persistence_context", null);){
            this.indexTestData(builder);
            FullTextSession fullTextSession = builder.openFullTextSession();
            Transaction tx = fullTextSession.beginTransaction();
            FullTextQuery query = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
            query.list();
            tx.commit();
            fullTextSession.close();
            Assert.assertEquals((String)"PersistenceContextObjectInitializer should have been used as object initializer", (long)1L, (long)this.byteman.getAndResetInvocationCount());
        }
    }

    @Test
    @BMRule(targetClass="org.hibernate.search.query.hibernate.impl.LookupObjectInitializer", targetMethod="initializeObjects(java.util.List, java.util.LinkedHashMap, org.hibernate.search.query.hibernate.impl.ObjectInitializationContext)", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()", name="testSetLookupMethodPersistenceContext")
    public void testSetDatabaseRetrievalMethodUpperCase() throws Exception {
        try (FullTextSessionBuilder builder = this.buildFullTextSessionBuilder(null, "FIND_BY_ID");){
            this.indexTestData(builder);
            FullTextSession fullTextSession = builder.openFullTextSession();
            Transaction tx = fullTextSession.beginTransaction();
            FullTextQuery query = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
            query.list();
            tx.commit();
            fullTextSession.close();
            Assert.assertEquals((String)"LookupObjectInitializer should have been used as object initializer", (long)1L, (long)this.byteman.getAndResetInvocationCount());
        }
    }

    @Test
    @BMRule(targetClass="org.hibernate.search.query.hibernate.impl.LookupObjectInitializer", targetMethod="initializeObjects(java.util.List, java.util.LinkedHashMap, org.hibernate.search.query.hibernate.impl.ObjectInitializationContext)", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()", name="testSetLookupMethodPersistenceContext")
    public void testSetDatabaseRetrievalMethodLoweCase() throws Exception {
        try (FullTextSessionBuilder builder = this.buildFullTextSessionBuilder(null, "find_by_id");){
            this.indexTestData(builder);
            FullTextSession fullTextSession = builder.openFullTextSession();
            Transaction tx = fullTextSession.beginTransaction();
            FullTextQuery query = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
            query.list();
            tx.commit();
            fullTextSession.close();
            Assert.assertEquals((String)"LookupObjectInitializer should have been used as object initializer", (long)1L, (long)this.byteman.getAndResetInvocationCount());
        }
    }

    @Test
    public void testSetInvalidLookupMethodThrowsException() throws Exception {
        try (FullTextSessionBuilder builder = this.buildFullTextSessionBuilder("foo", null);){
            Assert.fail((String)"The setup of the search factory should have failed due to invalid value.");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000217"));
        }
    }

    @Test
    public void testSetInvalidRetrievalMethodThrowsException() throws Exception {
        try (FullTextSessionBuilder builder = this.buildFullTextSessionBuilder(null, "foo");){
            Assert.fail((String)"The setup of the search factory should have failed due to invalid value.");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000217"));
        }
    }

    private FullTextSessionBuilder buildFullTextSessionBuilder(String objectLookUpMethod, String databaseRetrievalMethod) {
        FullTextSessionBuilder fullTextSessionBuilder = new FullTextSessionBuilder().addAnnotatedClass(Foo.class);
        if (objectLookUpMethod != null) {
            fullTextSessionBuilder.setProperty("hibernate.search.query.object_lookup_method", objectLookUpMethod);
        }
        if (databaseRetrievalMethod != null) {
            fullTextSessionBuilder.setProperty("hibernate.search.query.database_retrieval_method", databaseRetrievalMethod);
        }
        return fullTextSessionBuilder.build();
    }

    private void indexTestData(FullTextSessionBuilder builder) {
        FullTextSession session = builder.openFullTextSession();
        Transaction transaction = session.beginTransaction();
        Foo foo = new Foo();
        session.persist((Object)foo);
        Foo snafu = new Foo();
        session.persist((Object)snafu);
        transaction.commit();
        session.close();
    }

    @Indexed
    @Entity
    public static class Foo {
        @Id
        @GeneratedValue
        int id;
    }
}

