/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.test.batchindexing.LegacyCarPlantPK;

public class LegacyCarPlantPKBridge
implements TwoWayFieldBridge,
MetadataProvidingFieldBridge {
    private static final String PLANT_ID = "_content.plantId";
    private static final String CAR_ID = "_content.carId";

    public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
        builder.field(name + PLANT_ID, FieldType.STRING).field(name + CAR_ID, FieldType.STRING);
    }

    public Object get(String name, Document document) {
        LegacyCarPlantPK id = new LegacyCarPlantPK();
        IndexableField field = document.getField(name + PLANT_ID);
        id.setPlantId(field.stringValue());
        field = document.getField(name + CAR_ID);
        id.setCarId(field.stringValue());
        return id;
    }

    public String objectToString(Object o) {
        LegacyCarPlantPK id = (LegacyCarPlantPK)o;
        StringBuilder sb = new StringBuilder();
        sb.append(id.getPlantId()).append("-").append(id.getCarId());
        return sb.toString();
    }

    public void set(String name, Object o, Document document, LuceneOptions luceneOptions) {
        LegacyCarPlantPK id = (LegacyCarPlantPK)o;
        Field.Store store = luceneOptions.getStore();
        Field.Index index = luceneOptions.getIndex();
        Field.TermVector termVector = luceneOptions.getTermVector();
        Float boost = Float.valueOf(luceneOptions.getBoost());
        Field field = new Field(name + PLANT_ID, id.getPlantId(), store, index, termVector);
        field.setBoost(boost.floatValue());
        document.add((IndexableField)field);
        field = new Field(name + CAR_ID, id.getCarId(), store, index, termVector);
        field.setBoost(boost.floatValue());
        document.add((IndexableField)field);
    }
}

