/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.depth;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.depth.BrokenMammal;
import org.hibernate.search.test.embedded.depth.Person;
import org.hibernate.search.test.util.HibernateManualConfiguration;
import org.hibernate.search.testsupport.backend.LeakingLocalBackend;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Test;

public class RecursiveGraphTest
extends SearchTestBase {
    @Test
    public void testCorrectDepthIndexed() {
        this.prepareGenealogyTree();
        this.verifyMatchExistsWithName(1L, "name", "John of England");
        this.verifyNoMatchExists("parents.name", "John of England");
        this.verifyMatchExistsWithName(1L, "parents.name", "Henry II of England");
        this.verifyMatchExistsWithName(1L, "parents.parents.name", "Geoffrey V of Anjou");
        this.verifyMatchExistsWithName(2L, "parents.parents.name", "Fulk V of Anjou");
        this.verifyNoMatchExists("parents.parents.parents.name", "Fulk V of Anjou");
        LeakingLocalBackend.reset();
        this.renamePerson(1L, "John Lackland");
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(1L));
        Assert.assertEquals((long)0L, (long)this.countWorksDoneOnPerson(2L));
        LeakingLocalBackend.reset();
        this.renamePerson(2L, "Henry II of New England");
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(1L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(2L));
        LeakingLocalBackend.reset();
        this.renamePerson(16L, "Fulk 4th of Anjou");
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(16L));
        Assert.assertEquals((long)0L, (long)this.countWorksDoneOnPerson(17L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(8L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(4L));
        Assert.assertEquals((long)0L, (long)this.countWorksDoneOnPerson(2L));
        Assert.assertEquals((long)0L, (long)this.countWorksDoneOnPerson(1L));
    }

    @Test(expected=SearchException.class)
    public void testAgainstInfiniteTypeLoop() throws Exception {
        SearchConfigurationForTest configuration = new HibernateManualConfiguration().addClass(BrokenMammal.class);
        try {
            new SearchIntegratorBuilder().configuration((SearchConfiguration)configuration).buildSearchIntegrator();
        }
        catch (SearchException e) {
            Assertions.assertThat((String)e.getMessage()).contains("HSEARCH000221");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renamePerson(Long id, String newName) {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction transaction = fullTextSession.beginTransaction();
            Person kingJohn = (Person)fullTextSession.load(Person.class, (Serializable)id);
            kingJohn.setName(newName);
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyNoMatchExists(String fieldName, String fieldValue) {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction transaction = fullTextSession.beginTransaction();
            TermQuery q = new TermQuery(new Term(fieldName, fieldValue));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            int resultSize = fullTextQuery.getResultSize();
            Assert.assertEquals((long)0L, (long)resultSize);
            List list = fullTextQuery.list();
            Assert.assertEquals((long)0L, (long)list.size());
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyMatchExistsWithName(Long expectedId, String fieldName, String fieldValue) {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction transaction = fullTextSession.beginTransaction();
            TermQuery q = new TermQuery(new Term(fieldName, fieldValue));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            int resultSize = fullTextQuery.getResultSize();
            Assert.assertEquals((long)1L, (long)resultSize);
            List list = fullTextQuery.list();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)expectedId, (Object)((Person)list.get(0)).getId());
            transaction.commit();
        }
    }

    void prepareGenealogyTree() {
        int i;
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Person[] ps = new Person[18];
        ps[1] = new Person(1L, "John of England");
        ps[2] = new Person(2L, "Henry II of England");
        ps[3] = new Person(3L, "Eleanor of Aquitaine");
        ps[4] = new Person(4L, "Geoffrey V of Anjou");
        ps[5] = new Person(5L, "Empress Matilda");
        ps[6] = new Person(6L, "William X of Aquitaine");
        ps[7] = new Person(7L, "Aenor de Ch\u00e2tellerault");
        ps[8] = new Person(8L, "Fulk V of Anjou");
        ps[9] = new Person(9L, "Ermengarde of Maine");
        ps[10] = new Person(10L, "Henry I of England");
        ps[11] = new Person(11L, "Matilda of Scotland");
        ps[12] = new Person(12L, "William IX of Aquitaine");
        ps[13] = new Person(13L, "Philippa of Toulouse");
        ps[14] = new Person(14L, "Aimery I of Ch\u00e2ttellerault");
        ps[15] = new Person(15L, "Dangereuse de L'Isle Bouchard");
        ps[16] = new Person(16L, "Fulk IV of Anjou");
        ps[17] = new Person(17L, "Bertrade de Montfort");
        ps[1].addParents(ps[2], ps[3]);
        ps[2].addParents(ps[4], ps[5]);
        ps[3].addParents(ps[6], ps[7]);
        ps[4].addParents(ps[8], ps[9]);
        ps[5].addParents(ps[10], ps[11]);
        ps[6].addParents(ps[12], ps[13]);
        ps[7].addParents(ps[14], ps[15]);
        ps[8].addParents(ps[16], ps[17]);
        for (i = 1; i < 18; ++i) {
            session.save((Object)ps[i]);
        }
        transaction.commit();
        session.close();
        for (i = 1; i < 18; ++i) {
            Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(Long.valueOf(i)));
        }
    }

    private int countWorksDoneOnPerson(Long pk) {
        List processedQueue = LeakingLocalBackend.getLastProcessedQueue();
        int count = 0;
        for (LuceneWork luceneWork : processedQueue) {
            Serializable id = luceneWork.getId();
            if (!pk.equals(id)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Person.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.worker.backend", LeakingLocalBackend.class.getName());
    }
}

