/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.path;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2547")
public class DefaultPathsWithNestedIndexedEmbeddedTest
extends SearchTestBase {
    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{A.class, B.class, C.class};
    }

    @Test
    public void testIndexAndSearch() {
        try (Session session = this.openSession();){
            FullTextSession fts = Search.getFullTextSession((Session)session);
            Transaction tx = fts.beginTransaction();
            A a = new A();
            a.foo = "someValue";
            B b = new B();
            b.a = a;
            C c = new C();
            c.b = b;
            fts.persist((Object)a);
            fts.persist((Object)b);
            fts.persist((Object)c);
            tx.commit();
            fts.clear();
            tx = fts.beginTransaction();
            TermQuery query = new TermQuery(new Term("b.a.foo", a.foo));
            Assert.assertEquals((long)1L, (long)fts.createFullTextQuery((Query)query, new Class[]{C.class}).getResultSize());
            tx.commit();
            fts.clear();
        }
    }

    @Entity
    @Indexed
    private static class C {
        @Id
        @GeneratedValue
        private Long id;
        @OneToOne
        @IndexedEmbedded
        private B b;

        private C() {
        }
    }

    @Entity
    private static class B {
        @Id
        @GeneratedValue
        private Long id;
        @OneToOne
        @IndexedEmbedded(includePaths={"foo"})
        private A a;

        private B() {
        }
    }

    @Entity
    @Indexed
    private static class A {
        @Id
        @GeneratedValue
        private Long id;
        @Field(analyze=Analyze.NO)
        private String foo;

        private A() {
        }
    }
}

