/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.sorting;

import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.sorting.Hero;
import org.hibernate.search.test.embedded.sorting.Villain;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@TestForIssue(jiraKey="HSEARCH-2069")
public class EmbeddedSortableIdFieldTest
extends SearchTestBase {
    private static final String LEX = "Lex Luthor";
    private static final String DARKSEID = "Darkseid";
    private static final String CLARK = "Clark Kent";
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Before
    public void before() throws Exception {
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            Villain darkseid = new Villain(100, DARKSEID);
            Villain lex = new Villain(Integer.MIN_VALUE, LEX);
            Hero superman = new Hero(Integer.MAX_VALUE, CLARK);
            superman.setVillain(lex);
            lex.setHero(superman);
            superman.setSortableVillain(darkseid);
            darkseid.setHero(superman);
            session.save((Object)superman);
            session.save((Object)lex);
            transaction.commit();
        }
    }

    @Test
    public void testEntityCanSortOnId() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction transaction = fullTextSession.beginTransaction();
            Sort sort = new Sort(new SortField("id", SortField.Type.STRING));
            QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Villain.class).get();
            Query q = queryBuilder.keyword().onField("name").matching((Object)LEX).createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(q, new Class[]{Villain.class});
            fullTextQuery.setSort(sort);
            List list = fullTextQuery.list();
            Assertions.assertThat((List)list).hasSize(1);
            Villain actual = (Villain)list.get(0);
            Assertions.assertThat((String)actual.getName()).isEqualTo((Object)LEX);
            transaction.commit();
        }
    }

    @Test
    public void testSortingOnSortableFieldIncludedByIndexEmbedded() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction transaction = fullTextSession.beginTransaction();
            Sort sort = new Sort(new SortField("sortableVillain.id", SortField.Type.STRING));
            QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Hero.class).get();
            Query q = queryBuilder.keyword().onField("villain.name").matching((Object)LEX).createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(q, new Class[]{Hero.class});
            fullTextQuery.setSort(sort);
            List list = fullTextQuery.list();
            Assertions.assertThat((List)list).hasSize(1);
            Hero actual = (Hero)list.get(0);
            Assertions.assertThat((String)actual.getSecretIdentity()).isEqualTo((Object)CLARK);
            transaction.commit();
        }
    }

    @Test
    @Category(value={ElasticsearchSupportInProgress.class})
    public void testSortingOnSortableFieldNotIncludedByIndexEmbeddedException() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000301");
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction transaction = fullTextSession.beginTransaction();
            Sort sort = new Sort(new SortField("villain.id", SortField.Type.STRING));
            QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Hero.class).get();
            Query q = queryBuilder.keyword().onField("villain.name").matching((Object)LEX).createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(q, new Class[]{Hero.class});
            fullTextQuery.setSort(sort);
            fullTextQuery.list();
            transaction.commit();
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Hero.class, Villain.class};
    }
}

