/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.engine.BusLine;
import org.hibernate.search.test.engine.BusStop;
import org.hibernate.search.testsupport.readerprovider.FieldSelectorLeakingReaderProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LazyCollectionsUpdatingTest
extends SearchTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdatingInTransaction() {
        this.assertFindsByRoadName("buonarroti");
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction tx = fullTextSession.beginTransaction();
            FieldSelectorLeakingReaderProvider.resetFieldSelector();
            List list = fullTextSession.createCriteria(BusStop.class).list();
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((long)4L, (long)list.size());
            BusStop busStop = (BusStop)list.get(1);
            busStop.setRoadName("new road");
            tx.commit();
        }
        this.assertFindsByRoadName("new");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdatingOutOfTransaction() {
        this.assertFindsByRoadName("buonarroti");
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            List list = fullTextSession.createCriteria(BusStop.class).list();
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((long)4L, (long)list.size());
            BusStop busStop = (BusStop)list.get(1);
            busStop.setRoadName("new road");
            fullTextSession.flush();
        }
        this.assertFindsByRoadName("new");
    }

    public void assertFindsByRoadName(String analyzedRoadname) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        TermQuery ftQuery = new TermQuery(new Term("stops.roadName", analyzedRoadname));
        FullTextQuery query = fullTextSession.createFullTextQuery((Query)ftQuery, new Class[]{BusLine.class});
        query.setProjection(new String[]{"busLineName"});
        Assert.assertEquals((long)1L, (long)query.list().size());
        List results = query.list();
        String resultName = (String)((Object[])results.get(0))[0];
        Assert.assertEquals((Object)"Linea 64", (Object)resultName);
        tx.commit();
        fullTextSession.close();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.openSession();
        Transaction tx = null;
        try {
            tx = this.getSession().beginTransaction();
            BusLine bus = new BusLine();
            bus.setBusLineName("Linea 64");
            LazyCollectionsUpdatingTest.addBusStop(bus, "Stazione Termini");
            LazyCollectionsUpdatingTest.addBusStop(bus, "via Gregorio VII");
            LazyCollectionsUpdatingTest.addBusStop(bus, "via Alessandro III");
            LazyCollectionsUpdatingTest.addBusStop(bus, "via M. Buonarroti");
            this.getSession().persist((Object)bus);
            tx.commit();
        }
        catch (Throwable t) {
            if (tx != null) {
                tx.rollback();
            }
        }
        finally {
            this.getSession().close();
        }
    }

    static void addBusStop(BusLine bus, String roadName) {
        BusStop stop = new BusStop();
        stop.setRoadName(roadName);
        bus.getStops().add(stop);
        stop.getBusses().add(bus);
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{BusLine.class, BusStop.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.allow_update_outside_transaction", "true");
        cfg.put("hibernate.search.default.reader.strategy", FieldSelectorLeakingReaderProvider.class.getName());
        cfg.put("hibernate.search.analyzer", SimpleAnalyzer.class.getName());
    }
}

