/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter.fulltextfilterdefs;

import java.util.Map;
import org.fest.assertions.Assertions;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.spi.impl.SearchFactoryState;
import org.hibernate.search.test.filter.RoleFilterFactory;
import org.hibernate.search.test.util.HibernateManualConfiguration;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FullTextFilterDefsAnnotationTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(new Class[]{Sample.class});

    @Test
    public void shouldBeAbleToAnnotatePackage() throws Exception {
        this.assertThatFilterExists("package-filter-1");
        this.assertThatFilterExists("package-filter-2");
    }

    @Test
    public void shouldBeAbleToAnnotateClass() throws Exception {
        this.assertThatFilterExists("class-filter-1");
        this.assertThatFilterExists("class-filter-2");
    }

    @Test
    public void shouldContainsOnlyTheDefinedFilters() throws Exception {
        Map filterDefinitions = ((SearchFactoryState)this.sfHolder.getSearchFactory()).getFilterDefinitions();
        Assertions.assertThat(filterDefinitions.keySet()).contains(new Object[]{"package-filter-1", "package-filter-2", "class-filter-1", "class-filter-2"});
    }

    @Test
    public void shouldNotBePossibleToHaveTwoFilterDefsWithTheSameName() throws Exception {
        this.thrown.expect(SearchException.class);
        HibernateManualConfiguration cfg = new HibernateManualConfiguration();
        cfg.addClass(SampleWithError.class);
        new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator().close();
    }

    private void assertThatFilterExists(String filterName) {
        FilterDef filterDefinition = this.sfHolder.getSearchFactory().getFilterDefinition(filterName);
        Assertions.assertThat((Object)filterDefinition).isNotNull();
        Assertions.assertThat((Object)filterDefinition.getImpl()).isEqualTo(RoleFilterFactory.class);
    }

    @Indexed
    @FullTextFilterDefs(value={@FullTextFilterDef(name="package-filter-1", impl=RoleFilterFactory.class), @FullTextFilterDef(name="package-filter-unique", impl=RoleFilterFactory.class)})
    static class SampleWithError {
        @DocumentId
        final long id = 1L;
        @Field
        final String description = "";

        SampleWithError() {
        }
    }

    @Indexed
    @FullTextFilterDefs(value={@FullTextFilterDef(name="class-filter-1", impl=RoleFilterFactory.class), @FullTextFilterDef(name="class-filter-2", impl=RoleFilterFactory.class)})
    static class Sample {
        @DocumentId
        long id;
        @Field
        String description;

        Sample() {
        }
    }
}

