/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.dsl.Book;
import org.hibernate.search.test.query.dsl.Coffee;
import org.hibernate.search.test.query.dsl.CoffeeBrand;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Before;
import org.junit.Test;

public class SimpleQueryStringDSLTest
extends SearchTestBase {
    private FullTextSession fullTextSession;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.indexTestData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestForIssue(jiraKey="HSEARCH-2678")
    public void testSimpleQueryString() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        try {
            QueryBuilder qb = this.getCoffeeQueryBuilder();
            Query query = qb.simpleQueryString().onFields("name", new String[]{"summary", "description"}).withAndAsDefaultOperator().matching("balanced arabica").createQuery();
            FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Coffee.class});
            fullTextQuery.setSort(new Sort(new SortField("name_sort", SortField.Type.STRING)));
            List results = fullTextQuery.getResultList();
            this.compareCoffeeResultsAndExpected(Arrays.asList("Duls\u00e3o do Brasil", "Kazaar", "Livanto"), results);
            query = qb.simpleQueryString().onFields("name", new String[]{"summary", "description"}).withAndAsDefaultOperator().matching("-balanced arabica").createQuery();
            fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Coffee.class});
            fullTextQuery.setSort(new Sort(new SortField("name_sort", SortField.Type.STRING)));
            results = fullTextQuery.getResultList();
            this.compareCoffeeResultsAndExpected(Arrays.asList("Bukeela ka Ethiopia", "Linizio Lungo", "Volluto"), results);
            query = qb.simpleQueryString().onFields("name", new String[]{"summary", "description"}).withAndAsDefaultOperator().matching("powerful \"fruity note\"").createQuery();
            fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Coffee.class});
            fullTextQuery.setSort(new Sort(new SortField("name_sort", SortField.Type.STRING)));
            results = fullTextQuery.getResultList();
            this.compareCoffeeResultsAndExpected(Arrays.asList("Ristretto"), results);
            query = qb.simpleQueryString().onFields("name", new String[]{"summary", "description"}).matching("sweet robust").createQuery();
            fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Coffee.class});
            fullTextQuery.setSort(new Sort(new SortField("name_sort", SortField.Type.STRING)));
            results = fullTextQuery.getResultList();
            this.compareCoffeeResultsAndExpected(Arrays.asList("Caramelito", "Duls\u00e3o do Brasil", "Roma", "Volluto"), results);
        }
        finally {
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestForIssue(jiraKey="HSEARCH-2678")
    public void testBoost() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        try {
            QueryBuilder qb = this.getCoffeeQueryBuilder();
            Query query = qb.simpleQueryString().onFields("name", new String[]{"summary"}).boostedTo(5.0f).andField("description").withAndAsDefaultOperator().matching("fruity arabicas").createQuery();
            FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Coffee.class});
            fullTextQuery.setSort(new Sort(SortField.FIELD_SCORE));
            List results = fullTextQuery.getResultList();
            this.compareCoffeeResultsAndExpected(Arrays.asList("Rosabaya de Colombia", "Decaffeinato", "Ristretto"), results);
            query = qb.simpleQueryString().onFields("name", new String[]{"summary"}).andField("description").boostedTo(10.0f).withAndAsDefaultOperator().matching("fruity arabicas").createQuery();
            fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Coffee.class});
            fullTextQuery.setSort(new Sort(SortField.FIELD_SCORE));
            results = fullTextQuery.getResultList();
            this.compareCoffeeResultsAndExpected(Arrays.asList("Ristretto", "Rosabaya de Colombia", "Decaffeinato"), results);
        }
        finally {
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestForIssue(jiraKey="HSEARCH-2678")
    public void testFuzzy() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        try {
            QueryBuilder qb = this.getCoffeeQueryBuilder();
            Query query = qb.simpleQueryString().onFields("name", new String[]{"summary", "description"}).withAndAsDefaultOperator().matching("fruity arabica~2").createQuery();
            FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Coffee.class});
            fullTextQuery.setSort(new Sort(new SortField("name_sort", SortField.Type.STRING)));
            List results = fullTextQuery.getResultList();
            this.compareCoffeeResultsAndExpected(Arrays.asList("Decaffeinato", "Ristretto", "Rosabaya de Colombia", "Volluto"), results);
        }
        finally {
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestForIssue(jiraKey="HSEARCH-2678")
    public void testAnalyzer() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        try {
            QueryBuilder qb = this.getBookQueryBuilder();
            Query query = qb.simpleQueryString().onFields("title", new String[]{"author"}).withAndAsDefaultOperator().matching("Moli\u00e8re").createQuery();
            FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
            fullTextQuery.setSort(new Sort(new SortField("title", SortField.Type.STRING)));
            List results = fullTextQuery.getResultList();
            this.compareBookResultsAndExpected(Arrays.asList("Le Grand Moli\u00e8re illustr\u00e9", "Tartuffe"), results);
            query = qb.simpleQueryString().onFields("title", new String[]{"author"}).withAndAsDefaultOperator().matching("deplacait").createQuery();
            fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
            fullTextQuery.setSort(new Sort(new SortField("title", SortField.Type.STRING)));
            results = fullTextQuery.getResultList();
            this.compareBookResultsAndExpected(Arrays.asList("Le chat qui d\u00e9pla\u00e7ait des montagnes"), results);
            qb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Book.class).overridesForField("author", "titleAnalyzer").get();
            query = qb.simpleQueryString().onFields("title", new String[]{"author"}).withAndAsDefaultOperator().matching("Moli\u00e8re").createQuery();
            fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
            fullTextQuery.setSort(new Sort(new SortField("title", SortField.Type.STRING)));
            results = fullTextQuery.getResultList();
            this.compareBookResultsAndExpected(Arrays.asList("Dom Garcie de Navarre", "Le Grand Moli\u00e8re illustr\u00e9"), results);
        }
        finally {
            transaction.commit();
        }
    }

    private void compareCoffeeResultsAndExpected(List<String> expected, List<Coffee> results) {
        Assertions.assertThat(results).onProperty("name").isEqualTo(expected);
    }

    private void compareBookResultsAndExpected(List<String> expected, List<Book> results) {
        Assertions.assertThat(results).onProperty("title").isEqualTo(expected);
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Coffee.class, CoffeeBrand.class, Book.class};
    }

    private QueryBuilder getCoffeeQueryBuilder() {
        return this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Coffee.class).get();
    }

    private QueryBuilder getBookQueryBuilder() {
        return this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Book.class).get();
    }

    private void indexTestData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        CoffeeBrand brandPony = new CoffeeBrand();
        brandPony.setName("My little pony");
        brandPony.setDescription("Sells goods for horseback riding and good coffee blends");
        this.fullTextSession.persist((Object)brandPony);
        CoffeeBrand brandMonkey = new CoffeeBrand();
        brandMonkey.setName("Monkey Monkey Do");
        brandPony.setDescription("Offers mover services via monkeys instead of trucks for difficult terrains. Coffees from this brand make monkeys work much faster.");
        this.fullTextSession.persist((Object)brandMonkey);
        this.createCoffee("Kazaar", "EXCEPTIONALLY INTENSE AND SYRUPY", "A daring blend of two Robustas from Brazil and Guatemala, specially prepared for Nespresso, and a separately roasted Arabica from South America, Kazaar is a coffee of exceptional intensity. Its powerful bitterness and notes of pepper are balanced by a full and creamy texture.", 12, brandMonkey);
        this.createCoffee("Dharkan", "LONG ROASTED AND VELVETY", "This blend of Arabicas from Latin America and Asia fully unveils its character thanks to the technique of long roasting at a low temperature. Its powerful personality reveals intense roasted notes together with hints of bitter cocoa powder and toasted cereals that express themselves in a silky and velvety txture.", 11, brandPony);
        this.createCoffee("Ristretto", "POWERFUL AND CONTRASTING", "A blend of South American and East African Arabicas, with a touch of Robusta, roasted separately to create the subtle fruity note of this full-bodied, intense espresso.", 10, brandMonkey);
        this.createCoffee("Arpeggio", "INTENSE AND CREAMY", "A dark roast of pure South and Central American Arabicas, Arpeggio has a strong character and intense body, enhanced by cocoa notes.", 9, brandPony);
        this.createCoffee("Roma", "FULL AND BALANCED", "The balance of lightly roasted South and Central American Arabicas with Robusta, gives Roma sweet and woody notes and a full, lasting taste on the palate.", 8, brandMonkey);
        this.createCoffee("Livanto", "ROUND AND BALANCED", "A pure Arabica from South and Central America, Livanto is a well-balanced espresso characterised by a roasted caramelised note.", 6, brandMonkey);
        this.createCoffee("Capriccio", "RICH AND DISTINCTIVE", "Blending South American Arabicas with a touch of Robusta, Capriccio is an espresso with a rich aroma and a strong typical cereal note.", 5, brandMonkey);
        this.createCoffee("Volluto", "SWEET AND LIGHT", "A pure and lightly roasted Arabica from South America, Volluto reveals sweet and biscuity flavours, reinforced by a little acidity and a fruity note.", 4, brandMonkey);
        this.createCoffee("Cosi", "LIGHT AND LEMONY", "Pure, lightly roasted East African, Central and South American Arabicas make Cosi a light-bodied espresso with refreshing citrus notes.", 3, brandMonkey);
        this.createCoffee("Indriya from India", "POWERFUL AND SPICY", "Indriya from India is the noble marriage of Arabicas with a hint of Robusta from southern India. It is a full-bodied espresso, which has a distinct personality with notes of spices.", 10, brandMonkey);
        this.createCoffee("Rosabaya de Colombia", "FRUITY AND BALANCED", "This blend of fine, individually roasted Colombian Arabicas, develops a subtle acidity with typical red fruit and winey notes.", 6, brandMonkey);
        this.createCoffee("Duls\u00e3o do Brasil", "SWEET AND SATINY SMOOTH", "A pure Arabica coffee, Duls\u00e3o do Brasil is a delicate blend of red and yellow Bourbon beans from Brazil. Its satiny smooth, elegantly balanced flavor is enhanced with a note of delicately toasted grain.", 4, brandMonkey);
        this.createCoffee("Bukeela ka Ethiopia", "", "This delicate Lungo expresses a floral bouquet reminiscent of jasmine, white lily, bergamot and orange blossom together with notes of wood. A pure Arabica blend composed of two very different coffees coming from the birthplace of coffee, Ethiopia. The blend\u2019s coffees are roasted separately: one portion short and dark to guarantee the body, the other light but longer to preserve the delicate notes.", 3, brandMonkey);
        this.createCoffee("Fortissio Lungo", "RICH AND INTENSE", "Made from Central and South American Arabicas with just a hint of Robusta, Fortissio Lungo is an intense full-bodied blend with bitterness, which develops notes of dark roasted beans.", 7, brandMonkey);
        this.createCoffee("Vivalto Lungo", "COMPLEX AND BALANCED", "Vivalto Lungo is a balanced coffee made from a complex blend of separately roasted South American and East African Arabicas, combining roasted and subtle floral notes.", 4, brandMonkey);
        this.createCoffee("Linizio Lungo", "ROUND AND SMOOTH", "Mild and well-rounded on the palate, Linizio Lungo is a blend of fine Arabica enhancing malt and cereal notes.", 4, brandMonkey);
        this.createCoffee("Decaffeinato Intenso", "DENSE AND POWERFUL", "Dark roasted South American Arabicas with a touch of Robusta bring out the subtle cocoa and roasted cereal notes of this full-bodied decaffeinated espresso.", 7, brandMonkey);
        this.createCoffee("Decaffeinato Lungo", "LIGHT AND FULL-FLAVOURED", "The slow roasting of this blend of South American Arabicas with a touch of Robusta gives Decaffeinato Lungo a smooth, creamy body and roasted cereal flavour.", 3, brandMonkey);
        this.createCoffee("Decaffeinato", "FRUITY AND DELICATE", "A blend of South American Arabicas reinforced with just a touch of Robusta is lightly roasted to reveal an aroma of red fruit.", 2, brandPony);
        this.createCoffee("Caramelito", "CARAMEL FLAVOURED", "The sweet flavour of caramel softens the roasted notes of the Livanto Grand Cru. This delicate gourmet marriage evokes the creaminess of soft toffee.", 6, brandMonkey);
        this.createCoffee("Ciocattino", "CHOCOLATE FLAVOURED", "Dark and bitter chocolate notes meet the caramelized roast of the Livanto Grand Cru. A rich combination reminiscent of a square of dark chocolate.", 6, brandMonkey);
        this.createCoffee("Vanilio", "VANILLA FLAVOURED", "A balanced harmony between the rich and the velvety aromas of vanilla and the mellow flavour of the Livanto Grand Cru. A blend distinguished by its full flavour, infinitely smooth and silky on the palate.", 6, brandMonkey);
        this.fullTextSession.persist((Object)new Book(1L, "Le chat qui regardait les \u00e9toiles", "Lilian Jackson Braun"));
        this.fullTextSession.persist((Object)new Book(2L, "Le chat qui d\u00e9pla\u00e7ait des montagnes", "Lilian Jackson Braun"));
        this.fullTextSession.persist((Object)new Book(3L, "Le Grand Moli\u00e8re illustr\u00e9", "Caroline Guillot"));
        this.fullTextSession.persist((Object)new Book(4L, "Tartuffe", "Moli\u00e8re"));
        this.fullTextSession.persist((Object)new Book(5L, "Dom Garcie de Navarre", "moliere"));
        tx.commit();
        this.fullTextSession.clear();
    }

    private void createCoffee(String title, String summary, String description, int intensity, CoffeeBrand brand) {
        Coffee coffee = new Coffee();
        coffee.setName(title);
        coffee.setSummary(summary);
        coffee.setDescription(description);
        coffee.setIntensity(intensity);
        coffee.setBrand(brand);
        this.fullTextSession.persist((Object)coffee);
    }
}

