/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.statistics;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.Version;
import org.hibernate.search.stat.Statistics;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ElasticsearchSupportInProgress.class})
@RunWith(value=Parameterized.class)
public class StatisticsTest
extends SearchTestBase {
    private final String directoryProviderName;

    @Parameterized.Parameters(name="Directory provider {0}")
    public static Object[] data() {
        return new Object[]{"ram", "filesystem"};
    }

    public StatisticsTest(String directoryProviderName) {
        this.directoryProviderName = directoryProviderName;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{A.class, B.class};
    }

    @Override
    public void configure(Map<String, Object> settings) {
        settings.put("hibernate.search.generate_statistics", Boolean.TRUE.toString());
        settings.put("hibernate.search.default.directory_provider", this.directoryProviderName);
    }

    @After
    public void cleanupStats() {
        this.getStatistics().setStatisticsEnabled(true);
        this.getSearchFactory().getStatistics().clear();
    }

    @Test
    public void enabled() {
        Assert.assertTrue((boolean)this.getStatistics().isStatisticsEnabled());
        this.getStatistics().setStatisticsEnabled(false);
        Assert.assertFalse((boolean)this.getStatistics().isStatisticsEnabled());
        this.getStatistics().setStatisticsEnabled(true);
        Assert.assertTrue((boolean)this.getStatistics().isStatisticsEnabled());
    }

    @Test
    public void searchVersion() {
        Assert.assertEquals((Object)Version.getVersionString(), (Object)this.getStatistics().getSearchVersion());
    }

    @Test
    public void indexedClassNames() {
        Set indexedClassNames = this.getStatistics().getIndexedClassNames();
        Assert.assertEquals((long)2L, (long)indexedClassNames.size());
        Assert.assertTrue((boolean)indexedClassNames.contains(A.class.getName()));
        Assert.assertTrue((boolean)indexedClassNames.contains(B.class.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void indexedEntitiesCount() {
        Map indexedEntitiesCount = this.getStatistics().indexedEntitiesCount();
        Assert.assertEquals((long)2L, (long)indexedEntitiesCount.size());
        Assert.assertEquals((Object)0, indexedEntitiesCount.get(A.class.getName()));
        Assert.assertEquals((Object)0, indexedEntitiesCount.get(B.class.getName()));
        Assert.assertEquals((long)0L, (long)this.getStatistics().getNumberOfIndexedEntities(A.class.getName()));
        Assert.assertEquals((long)0L, (long)this.getStatistics().getNumberOfIndexedEntities(B.class.getName()));
        try (Session s = this.openSession();){
            A entity = new A();
            entity.id = 1L;
            Transaction tx = s.beginTransaction();
            s.persist((Object)entity);
            tx.commit();
        }
        indexedEntitiesCount = this.getStatistics().indexedEntitiesCount();
        Assert.assertEquals((long)2L, (long)indexedEntitiesCount.size());
        Assert.assertEquals((Object)1, indexedEntitiesCount.get(A.class.getName()));
        Assert.assertEquals((Object)0, indexedEntitiesCount.get(B.class.getName()));
        Assert.assertEquals((long)1L, (long)this.getStatistics().getNumberOfIndexedEntities(A.class.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryExecution() {
        try (Session s = this.openSession();){
            FullTextSession session = Search.getFullTextSession((Session)s);
            FullTextQuery query = session.createFullTextQuery(this.matchAll(), new Class[]{A.class});
            Assert.assertEquals((long)0L, (long)this.getStatistics().getSearchQueryExecutionCount());
            Assert.assertEquals((long)0L, (long)this.getStatistics().getSearchQueryExecutionAvgTime());
            Assert.assertEquals((long)0L, (long)this.getStatistics().getSearchQueryExecutionMaxTime());
            Assert.assertNull((Object)this.getStatistics().getSearchQueryExecutionMaxTimeQueryString());
            query.getResultList();
            Assert.assertEquals((long)1L, (long)this.getStatistics().getSearchQueryExecutionCount());
            Assert.assertNotEquals((long)0L, (long)this.getStatistics().getSearchQueryExecutionAvgTime());
            Assert.assertNotEquals((long)0L, (long)this.getStatistics().getSearchQueryExecutionMaxTime());
            Assert.assertNotNull((Object)this.getStatistics().getSearchQueryExecutionMaxTimeQueryString());
            query = session.createFullTextQuery(this.matchAll(), new Class[]{A.class});
            query.getResultList();
            Assert.assertEquals((long)2L, (long)this.getStatistics().getSearchQueryExecutionCount());
            Assert.assertNotEquals((long)0L, (long)this.getStatistics().getSearchQueryExecutionAvgTime());
            Assert.assertNotEquals((long)0L, (long)this.getStatistics().getSearchQueryExecutionMaxTime());
            Assert.assertNotNull((Object)this.getStatistics().getSearchQueryExecutionMaxTimeQueryString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void objectLoading() {
        try (Session s = this.openSession();){
            Transaction tx = s.beginTransaction();
            A entity = new A();
            entity.id = 1L;
            s.persist((Object)entity);
            tx.commit();
            FullTextSession session = Search.getFullTextSession((Session)s);
            FullTextQuery query = session.createFullTextQuery(this.matchAll(), new Class[]{A.class});
            Assert.assertEquals((long)0L, (long)this.getStatistics().getObjectsLoadedCount());
            Assert.assertEquals((long)0L, (long)this.getStatistics().getObjectLoadingExecutionAvgTime());
            Assert.assertEquals((long)0L, (long)this.getStatistics().getObjectLoadingExecutionMaxTime());
            Assert.assertEquals((long)0L, (long)this.getStatistics().getObjectLoadingTotalTime());
            query.getResultList();
            Assert.assertEquals((long)1L, (long)this.getStatistics().getObjectsLoadedCount());
            Assert.assertNotEquals((long)0L, (long)this.getStatistics().getObjectLoadingExecutionAvgTime());
            Assert.assertNotEquals((long)0L, (long)this.getStatistics().getObjectLoadingExecutionMaxTime());
            Assert.assertNotEquals((long)0L, (long)this.getStatistics().getObjectLoadingTotalTime());
            query = session.createFullTextQuery(this.matchAll(), new Class[]{A.class});
            query.getResultList();
            Assert.assertEquals((long)2L, (long)this.getStatistics().getObjectsLoadedCount());
            Assert.assertNotEquals((long)0L, (long)this.getStatistics().getObjectLoadingExecutionAvgTime());
            Assert.assertNotEquals((long)0L, (long)this.getStatistics().getObjectLoadingExecutionMaxTime());
            Assert.assertNotEquals((long)0L, (long)this.getStatistics().getObjectLoadingTotalTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestForIssue(jiraKey="HSEARCH-2630")
    public void objectLoading_multiClassesQueryLoader_singleResult() {
        try (Session s = this.openSession();){
            Transaction tx = s.beginTransaction();
            A entity = new A();
            entity.id = 1L;
            s.persist((Object)entity);
            tx.commit();
            FullTextSession session = Search.getFullTextSession((Session)s);
            FullTextQuery query = session.createFullTextQuery(this.matchAll(), new Class[]{A.class, B.class});
            Assert.assertEquals((long)0L, (long)this.getStatistics().getObjectsLoadedCount());
            query.getResultList();
            Assert.assertEquals((long)1L, (long)this.getStatistics().getObjectsLoadedCount());
            query = session.createFullTextQuery(this.matchAll(), new Class[]{A.class, B.class});
            query.getResultList();
            Assert.assertEquals((long)2L, (long)this.getStatistics().getObjectsLoadedCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestForIssue(jiraKey="HSEARCH-2631")
    public void objectLoading_singleClassQueryLoader_criteria_iterate() {
        try (Session s = this.openSession();){
            Transaction tx = s.beginTransaction();
            A entity = new A();
            entity.id = 1L;
            s.persist((Object)entity);
            tx.commit();
            FullTextSession session = Search.getFullTextSession((Session)s);
            FullTextQuery query = session.createFullTextQuery(this.matchAll(), new Class[0]).setCriteriaQuery(session.createCriteria(A.class));
            Assert.assertEquals((long)0L, (long)this.getStatistics().getObjectsLoadedCount());
            Iterator iterator = query.iterate();
            iterator.next();
            Assert.assertEquals((long)1L, (long)this.getStatistics().getObjectsLoadedCount());
            query = session.createFullTextQuery(this.matchAll(), new Class[]{A.class});
            iterator = query.iterate();
            iterator.next();
            Assert.assertEquals((long)2L, (long)this.getStatistics().getObjectsLoadedCount());
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2014")
    public void indexSize() {
        long currentSizeForA = this.getStatistics().getIndexSize(A.INDEX_NAME);
        long currentSizeForB = this.getStatistics().getIndexSize("B");
        Map indexSizes = this.getStatistics().indexSizes();
        Assert.assertEquals((long)2L, (long)indexSizes.size());
        Assert.assertEquals((Object)currentSizeForA, indexSizes.get(A.INDEX_NAME));
        Assert.assertEquals((Object)currentSizeForB, indexSizes.get("B"));
        try (Session s = this.openSession();){
            A entity = new A();
            entity.id = 1L;
            Transaction tx = s.beginTransaction();
            s.persist((Object)entity);
            tx.commit();
        }
        long previousSizeForA = currentSizeForA;
        long previousSizeForB = currentSizeForB;
        currentSizeForA = this.getStatistics().getIndexSize(A.INDEX_NAME);
        currentSizeForB = this.getStatistics().getIndexSize("B");
        Assert.assertTrue((currentSizeForA > previousSizeForA ? 1 : 0) != 0);
        Assert.assertEquals((long)previousSizeForB, (long)currentSizeForB);
        indexSizes = this.getStatistics().indexSizes();
        Assert.assertEquals((long)2L, (long)indexSizes.size());
        Assert.assertEquals((Object)currentSizeForA, indexSizes.get(A.INDEX_NAME));
        Assert.assertEquals((Object)currentSizeForB, indexSizes.get("B"));
        try (Session s = this.openSession();){
            A entity = new A();
            entity.id = 2L;
            Transaction tx = s.beginTransaction();
            s.persist((Object)entity);
            tx.commit();
        }
        previousSizeForA = currentSizeForA;
        previousSizeForB = currentSizeForB;
        currentSizeForA = this.getStatistics().getIndexSize(A.INDEX_NAME);
        currentSizeForB = this.getStatistics().getIndexSize("B");
        Assert.assertTrue((currentSizeForA > previousSizeForA ? 1 : 0) != 0);
        Assert.assertEquals((long)previousSizeForB, (long)currentSizeForB);
        indexSizes = this.getStatistics().indexSizes();
        Assert.assertEquals((long)2L, (long)indexSizes.size());
        Assert.assertEquals((Object)currentSizeForA, indexSizes.get(A.INDEX_NAME));
        Assert.assertEquals((Object)currentSizeForB, indexSizes.get("B"));
    }

    private Statistics getStatistics() {
        return this.getSearchFactory().getStatistics();
    }

    private Query matchAll() {
        return new MatchAllDocsQuery();
    }

    @Entity
    @Indexed(index="B")
    private static class B {
        public static final String INDEX_NAME = "B";
        @Id
        private Long id;
        @Field
        private String field;

        private B() {
        }
    }

    @Entity
    @Indexed
    private static class A {
        public static final String INDEX_NAME = A.class.getName();
        @Id
        private Long id;
        @Field
        private String field;

        private A() {
        }
    }
}

