/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend;

import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.store.optimization.impl.IncrementalOptimizerStrategy;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.backend.Clock;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class OptimizationTriggerTest
extends SearchTestBase {
    @Test
    public void testOptimizationIsTriggered() throws InterruptedException {
        DirectoryBasedIndexManager indexManager = this.getSingleIndexManager(Clock.class);
        OptimizerStrategy optimizerStrategy = indexManager.getOptimizerStrategy();
        Assert.assertTrue((String)"Unexpected optimizer strategy", (boolean)(optimizerStrategy instanceof IncrementalOptimizerStrategy));
        IncrementalOptimizerStrategy strategy = (IncrementalOptimizerStrategy)optimizerStrategy;
        Assert.assertEquals((String)"Initially no optimisation should have been performed", (long)0L, (long)strategy.getOptimizationsPerformed());
        Session session = this.openSession();
        long optimizationsPerformed = 0L;
        for (int i = 0; i < 20; ++i) {
            Clock c = new Clock(i, "hwd" + i);
            Transaction transaction = session.beginTransaction();
            session.persist((Object)c);
            transaction.commit();
            session.clear();
            optimizationsPerformed = strategy.getOptimizationsPerformed();
            Assert.assertEquals((String)"Optimization should be triggered every three inserts", (long)((i + 1) / 3), (long)optimizationsPerformed);
        }
        session.close();
        session = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{Clock.class});
        int resultSize = fullTextQuery.getResultSize();
        Assert.assertEquals((String)"Wrong number of indexed entities", (long)20L, (long)resultSize);
        Assert.assertEquals((String)"Optimization should not have changed", (long)optimizationsPerformed, (long)strategy.getOptimizationsPerformed());
        fullTextSession.getSearchFactory().optimize(Clock.class);
        Assert.assertEquals((String)"Optimize should have been incremented", (long)(optimizationsPerformed + 1L), (long)strategy.getOptimizationsPerformed());
        fullTextSession.createIndexer(new Class[]{Clock.class}).optimizeAfterPurge(true).optimizeOnFinish(true).startAndWait();
        Assert.assertEquals((String)"The mass indexer should trigger optimize as well ", (long)(optimizationsPerformed + 3L), (long)strategy.getOptimizationsPerformed());
        session.close();
    }

    private DirectoryBasedIndexManager getSingleIndexManager(Class<?> clazz) {
        SearchIntegrator searchIntegrator = (SearchIntegrator)this.getSearchFactory().unwrap(SearchIntegrator.class);
        EntityIndexBinding indexBindingForEntity = (EntityIndexBinding)searchIntegrator.getIndexBindings().get(clazz);
        Set indexManagers = indexBindingForEntity.getIndexManagerSelector().all();
        Assert.assertEquals((long)1L, (long)indexManagers.size());
        return (DirectoryBasedIndexManager)indexManagers.iterator().next();
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.optimizer.operation_limit.max", "3");
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }
}

