/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.ShortBridge;
import org.hibernate.search.bridge.util.impl.BridgeAdaptor;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.Unit;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.spatial.SpatialQueryBuilder;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.configuration.Address;
import org.hibernate.search.test.configuration.BlogEntry;
import org.hibernate.search.test.configuration.ClassLevelTestPoI;
import org.hibernate.search.test.configuration.Country;
import org.hibernate.search.test.configuration.Departments;
import org.hibernate.search.test.configuration.DynamicBoostedDescLibrary;
import org.hibernate.search.test.configuration.Item;
import org.hibernate.search.test.configuration.LatLongAnnTestPoi;
import org.hibernate.search.test.configuration.MemberLevelTestPoI;
import org.hibernate.search.test.configuration.OrderLine;
import org.hibernate.search.test.configuration.ProductCatalog;
import org.hibernate.search.test.configuration.ProgrammaticSearchMappingFactory;
import org.hibernate.search.test.configuration.ProvidedIdEntry;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class ProgrammaticMappingTest
extends SearchTestBase {
    private static final Log log = LoggerFactory.make();

    @Test
    public void testMapping() throws Exception {
        Address address = new Address();
        address.setStreet1("3340 Peachtree Rd NE");
        address.setStreet2("JBoss");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("" + address.getAddressId());
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        Assert.assertEquals((String)"documentId does not work properly", (long)1L, (long)query.getResultSize());
        luceneQuery = parser.parse("street1:peachtree");
        query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"idx_street2", "__HSearch_This"});
        Assert.assertEquals((String)"Not properly indexed", (long)1L, (long)query.getResultSize());
        Object[] firstResult = (Object[])query.list().get(0);
        Assert.assertEquals((String)"@Field.store not respected", (Object)"JBoss", (Object)firstResult[0]);
        luceneQuery = parser.parse("AddressClassBridge:Applied\\!");
        Assert.assertEquals((long)1L, (long)s.createFullTextQuery(luceneQuery, new Class[0]).getResultSize());
        s.delete(firstResult[1]);
        tx.commit();
        s.close();
    }

    @Test
    public void testNumeric() throws Exception {
        Assert.assertEquals((Object)NumericFieldBridge.SHORT_FIELD_BRIDGE, (Object)this.getUnwrappedBridge(Item.class, "price", NumericFieldBridge.class));
        Assert.assertNotNull((Object)this.getUnwrappedBridge(Item.class, "price_string", ShortBridge.class));
    }

    private Object getUnwrappedBridge(Class<?> clazz, String string, Class<?> expectedBridgeClass) {
        FieldBridge bridge = ((EntityIndexBinding)this.getExtendedSearchIntegrator().getIndexBindings().get(clazz)).getDocumentBuilder().getTypeMetadata().getDocumentFieldMetadataFor(string).getFieldBridge();
        return this.unwrapBridge(bridge, expectedBridgeClass);
    }

    private Object unwrapBridge(Object bridge, Class<?> expectedBridgeClass) {
        if (bridge instanceof BridgeAdaptor) {
            return ((BridgeAdaptor)bridge).unwrap(expectedBridgeClass);
        }
        return bridge;
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2651")
    public void testNumericDoesNotDuplicateField() throws Exception {
        TypeMetadata metadata = ((EntityIndexBinding)this.getExtendedSearchIntegrator().getIndexBindings().get(Item.class)).getDocumentBuilder().getTypeMetadata();
        Assert.assertTrue((boolean)metadata.getDocumentFieldMetadataFor("price").isNumeric());
        Assert.assertEquals((Object)Store.YES, (Object)metadata.getDocumentFieldMetadataFor("price").getStore());
    }

    @Test
    public void testSortableField() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Item item1 = new Item();
        item1.setId(3);
        item1.setPrice((short)3454);
        s.persist((Object)item1);
        Item item2 = new Item();
        item2.setId(2);
        item2.setPrice((short)3354);
        s.persist((Object)item2);
        Item item3 = new Item();
        item3.setId(1);
        item3.setPrice((short)3554);
        s.persist((Object)item3);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        Query q = s.getSearchFactory().buildQueryBuilder().forEntity(Item.class).get().all().createQuery();
        FullTextQuery query = s.createFullTextQuery(q, new Class[]{Item.class});
        query.setSort(new Sort(new SortField("price", SortField.Type.INT)));
        List results = query.list();
        ((ListAssert)Assertions.assertThat((List)results).onProperty("price").describedAs("Sortable field via programmatic config")).containsExactly(new Object[]{(short)3354, (short)3454, (short)3554});
        query.setSort(new Sort(new SortField("id", SortField.Type.STRING)));
        results = query.list();
        ((ListAssert)Assertions.assertThat((List)results).onProperty("id").describedAs("Sortable field via programmatic config")).containsExactly(new Object[]{1, 2, 3});
        s.delete(results.get(0));
        s.delete(results.get(1));
        s.delete(results.get(2));
        tx.commit();
        s.close();
    }

    @Test
    public void testFacet() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Item item1 = new Item();
        item1.setId(3);
        item1.setPrice((short)25);
        s.persist((Object)item1);
        Item item2 = new Item();
        item2.setId(2);
        item2.setPrice((short)35);
        s.persist((Object)item2);
        Item item3 = new Item();
        item3.setId(1);
        item3.setPrice((short)825);
        s.persist((Object)item3);
        Item item4 = new Item();
        item4.setId(4);
        item4.setPrice((short)2089);
        s.persist((Object)item4);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryBuilder qb = s.getSearchFactory().buildQueryBuilder().forEntity(Item.class).get();
        Query q = qb.all().createQuery();
        FullTextQuery query = s.createFullTextQuery(q, new Class[]{Item.class});
        FacetingRequest facetingRequest = qb.facet().name("myFacet").onField("price_facet").range().below((Object)50.0).excludeLimit().from((Object)50.0).to((Object)1000.0).excludeLimit().above((Object)1000.0).createFacetingRequest();
        query.getFacetManager().enableFaceting(facetingRequest);
        List results = query.list();
        List facets = query.getFacetManager().getFacets("myFacet");
        ((ListAssert)Assertions.assertThat((List)facets).onProperty("value").describedAs("Retrieved facets - values")).containsExactly(new Object[]{"[, 50.0)", "[50.0, 1000.0)", "[1000.0, ]"});
        ((ListAssert)Assertions.assertThat((List)facets).onProperty("count").describedAs("Retrieved facets - counts")).containsExactly(new Object[]{2, 1, 1});
        query.setSort(new Sort(new SortField("id", SortField.Type.STRING)));
        s.delete(results.get(0));
        s.delete(results.get(1));
        s.delete(results.get(2));
        s.delete(results.get(3));
        tx.commit();
        s.close();
    }

    @Test
    public void testAnalyzerDef() throws Exception {
        Address address = new Address();
        address.setStreet1("3340 Peachtree Rd NE");
        address.setStreet2("JBoss");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("street1_ngram:pea");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        Assert.assertEquals((String)"Analyzer inoperant", (long)1L, (long)query.getResultSize());
        s.delete(query.list().get(0));
        tx.commit();
        s.close();
    }

    @Test
    public void testNormalizerDef() throws Exception {
        Address address = new Address();
        address.setStreet1("3340 Peachtree Rd NE");
        address.setStreet2("JBoss");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        TermQuery luceneQuery = new TermQuery(new Term("street1_normalized", "3340 peachtree rd ne"));
        FullTextQuery query = s.createFullTextQuery((Query)luceneQuery, new Class[0]);
        Assert.assertEquals((String)"Normalizer inoperant", (long)1L, (long)query.getResultSize());
        s.delete(query.list().get(0));
        tx.commit();
        s.close();
    }

    @Test
    public void testBridgeMapping() throws Exception {
        Address address = new Address();
        address.setStreet1("Peachtree Rd NE");
        address.setStreet2("JBoss");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("street1:peac");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        Assert.assertEquals((String)"PrefixQuery should not be on", (long)0L, (long)query.getResultSize());
        luceneQuery = parser.parse("street1_abridged:peac");
        query = s.createFullTextQuery(luceneQuery, new Class[0]);
        Assert.assertEquals((String)"Bridge not used", (long)1L, (long)query.getResultSize());
        s.delete(query.list().get(0));
        tx.commit();
        s.close();
    }

    @Test
    public void testBoost() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Address address = new Address();
        address.setStreet1("Peachtree Rd NE");
        address.setStreet2("Peachtnot Rd NE");
        s.persist((Object)address);
        address = new Address();
        address.setStreet1("Peachtnot Rd NE");
        address.setStreet2("Peachtree Rd NE");
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("street1:peachtree OR idx_street2:peachtree");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        Assert.assertEquals((String)"expecting two results", (long)2L, (long)query.getResultSize());
        List results = query.list();
        Assert.assertTrue((String)"first result should be strictly higher", (((Float)((Object[])results.get(0))[1]).floatValue() > ((Float)((Object[])results.get(1))[1]).floatValue() * 1.9f ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong result ordered", (Object)address.getStreet1(), (Object)((Address)((Object[])results.get(0))[0]).getStreet1());
        for (Object[] result : results) {
            s.delete(result[0]);
        }
        tx.commit();
        s.close();
    }

    @Test
    @Category(value={ElasticsearchSupportInProgress.class})
    public void testAnalyzerDiscriminator() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        BlogEntry deEntry = new BlogEntry();
        deEntry.setTitle("aufeinanderschl\u00fcgen");
        deEntry.setDescription("aufeinanderschl\u00fcgen");
        deEntry.setLanguage("de");
        s.persist((Object)deEntry);
        BlogEntry enEntry = new BlogEntry();
        enEntry.setTitle("acknowledgment");
        enEntry.setDescription("acknowledgment");
        enEntry.setLanguage("en");
        s.persist((Object)enEntry);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        Assert.assertEquals((long)1L, (long)this.nbrOfMatchingResults("description", "aufeinanderschlug", s));
        Assert.assertEquals((long)1L, (long)this.nbrOfMatchingResults("description", "acknowledg", s));
        Assert.assertEquals((long)0L, (long)this.nbrOfMatchingResults("title", "aufeinanderschlug", s));
        Assert.assertEquals((long)1L, (long)this.nbrOfMatchingResults("title", "acknowledgment", s));
        for (Object result : s.createQuery("from " + BlogEntry.class.getName()).list()) {
            s.delete(result);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testDateBridgeMapping() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Address address = new Address();
        address.setStreet1("Peachtree Rd NE");
        address.setStreet2("Peachtnot Rd NE");
        Calendar c = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        c.set(2009, 10, 15);
        Date date = new Date(c.getTimeInMillis());
        address.setDateCreated(date);
        s.persist((Object)address);
        address = new Address();
        address.setStreet1("Peachtnot Rd NE");
        address.setStreet2("Peachtree Rd NE");
        address.setDateCreated(date);
        s.persist((Object)address);
        BlogEntry enEntry = new BlogEntry();
        enEntry.setTitle("acknowledgment");
        enEntry.setDescription("acknowledgment");
        enEntry.setLanguage("en");
        enEntry.setDateCreated(date);
        s.persist((Object)enEntry);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        long searchTimeStamp = DateTools.round((long)date.getTime(), (DateTools.Resolution)DateTools.Resolution.DAY);
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        booleanQueryBuilder.add((Query)NumericRangeQuery.newLongRange((String)"date-created", (Long)searchTimeStamp, (Long)searchTimeStamp, (boolean)true, (boolean)true), BooleanClause.Occur.SHOULD);
        booleanQueryBuilder.add((Query)NumericRangeQuery.newLongRange((String)"blog-entry-created", (Long)searchTimeStamp, (Long)searchTimeStamp, (boolean)true, (boolean)true), BooleanClause.Occur.SHOULD);
        FullTextQuery query = s.createFullTextQuery((Query)booleanQueryBuilder.build(), new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        Assert.assertEquals((String)"expecting 3 results", (long)3L, (long)query.getResultSize());
        List results = query.list();
        for (Object[] result : results) {
            s.delete(result[0]);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testCalendarBridgeMapping() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Address address = new Address();
        address.setStreet1("Peachtree Rd NE");
        address.setStreet2("Peachtnot Rd NE");
        Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        calendar.set(2009, 10, 15);
        address.setLastUpdated(calendar);
        s.persist((Object)address);
        address = new Address();
        address.setStreet1("Peachtnot Rd NE");
        address.setStreet2("Peachtree Rd NE");
        address.setLastUpdated(calendar);
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        long searchTimeStamp = DateTools.round((long)calendar.getTime().getTime(), (DateTools.Resolution)DateTools.Resolution.DAY);
        NumericRangeQuery luceneQuery = NumericRangeQuery.newLongRange((String)"last-updated", (Long)searchTimeStamp, (Long)searchTimeStamp, (boolean)true, (boolean)true);
        FullTextQuery query = s.createFullTextQuery((Query)luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        Assert.assertEquals((String)"expecting 2 results", (long)2L, (long)query.getResultSize());
        List results = query.list();
        for (Object[] result : results) {
            s.delete(result[0]);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testProvidedIdMapping() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        SearchIntegrator sf = (SearchIntegrator)fullTextSession.getSearchFactory().unwrap(SearchIntegrator.class);
        ProvidedIdEntry person1 = new ProvidedIdEntry();
        person1.setName("Big Goat");
        person1.setBlurb("Eats grass");
        ProvidedIdEntry person2 = new ProvidedIdEntry();
        person2.setName("Mini Goat");
        person2.setBlurb("Eats cheese");
        ProvidedIdEntry person3 = new ProvidedIdEntry();
        person3.setName("Regular goat");
        person3.setBlurb("Is anorexic");
        SearchITHelper helper = new SearchITHelper(() -> sf);
        helper.index().push((Object)person1, (Serializable)Integer.valueOf(1)).push((Object)person2, (Serializable)Integer.valueOf(2)).push((Object)person3, (Serializable)Integer.valueOf(3)).execute();
        Transaction transaction = fullTextSession.beginTransaction();
        helper.assertThat("providedidentry.name", "goat").from(new Class[]{ProvidedIdEntry.class}).hasResultSize(3);
        transaction.commit();
        this.getSession().close();
    }

    @Test
    public void testFullTextFilterDefAtMappingLevel() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Address address = new Address();
        address.setStreet1("Peachtree Rd NE");
        address.setStreet2("Peachtnot Rd NE");
        address.setOwner("test");
        Calendar c = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        c.set(2009, 10, 15);
        address.setLastUpdated(c);
        s.persist((Object)address);
        address = new Address();
        address.setStreet1("Peachtnot Rd NE");
        address.setStreet2("Peachtree Rd NE");
        address.setLastUpdated(c);
        address.setOwner("testowner");
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("street1:Peachtnot");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        query.enableFullTextFilter("security").setParameter("ownerName", (Object)"testowner");
        Assert.assertEquals((String)"expecting 1 results", (long)1L, (long)query.getResultSize());
        List results = query.list();
        for (Object[] result : results) {
            s.delete(result[0]);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testIndexEmbedded() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        ProductCatalog productCatalog = new ProductCatalog();
        productCatalog.setName("Cars");
        Item item = new Item();
        item.setId(1);
        item.setDescription("Ferrari");
        item.setProductCatalog(productCatalog);
        productCatalog.addItem(item);
        s.persist((Object)item);
        s.persist((Object)productCatalog);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("items.description:Ferrari");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        Assert.assertEquals((String)"expecting 1 results", (long)1L, (long)query.getResultSize());
        List results = query.list();
        for (Object[] result : results) {
            s.delete(result[0]);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testContainedIn() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        ProductCatalog productCatalog = new ProductCatalog();
        productCatalog.setName("Cars");
        Item item = new Item();
        item.setId(1);
        item.setDescription("test");
        item.setProductCatalog(productCatalog);
        productCatalog.addItem(item);
        s.persist((Object)item);
        s.persist((Object)productCatalog);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("items.description:test");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        Assert.assertEquals((String)"expecting 1 results", (long)1L, (long)query.getResultSize());
        tx.commit();
        tx = s.beginTransaction();
        Item loaded = (Item)s.get(Item.class, (Serializable)item.getId());
        loaded.setDescription("Ferrari");
        s.update((Object)loaded);
        tx.commit();
        tx = s.beginTransaction();
        parser = new QueryParser("id", TestConstants.standardAnalyzer);
        luceneQuery = parser.parse("items.description:test");
        query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        Assert.assertEquals((String)"expecting 0 results", (long)0L, (long)query.getResultSize());
        parser = new QueryParser("id", TestConstants.standardAnalyzer);
        luceneQuery = parser.parse("items.description:Ferrari");
        query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        Assert.assertEquals((String)"expecting 1 results", (long)1L, (long)query.getResultSize());
        tx.commit();
        tx = s.beginTransaction();
        List results = query.list();
        for (Object[] result : results) {
            s.delete(result[0]);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testClassBridgeMapping() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)this.getDepts1());
        s.persist((Object)this.getDepts2());
        s.persist((Object)this.getDepts3());
        s.persist((Object)this.getDepts4());
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser("equipment", (Analyzer)new SimpleAnalyzer());
        Query query = parser.parse("equiptype:Cisco");
        FullTextQuery hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"incorrect number of results returned", (long)2L, (long)result.size());
        for (Departments d : result) {
            Assert.assertEquals((String)"incorrect manufacturer", (Object)"C", (Object)d.getManufacturer());
        }
        query = parser.parse("branchnetwork:Kent Lewin");
        hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)"problem with field cross-ups", (result.size() == 0 ? 1 : 0) != 0);
        parser = new QueryParser("branchHead", (Analyzer)new SimpleAnalyzer());
        query = parser.parse("branchHead:Kent Lewin");
        hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)"incorrect entity returned, wrong branch head", (result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"incorrect entity returned", (Object)"Kent Lewin", (Object)((Departments)result.get(0)).getBranchHead());
        parser = new QueryParser("branchnetwork", (Analyzer)new SimpleAnalyzer());
        query = parser.parse("branchnetwork:st. george 1D");
        hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"incorrect entity returned, wrong network", (Object)"1D", (Object)((Departments)result.get(0)).getNetwork());
        Assert.assertEquals((String)"incorrect entity returned, wrong branch", (Object)"St. George", (Object)((Departments)result.get(0)).getBranch());
        Assert.assertEquals((String)"incorrect number of results returned", (long)1L, (long)result.size());
        for (Object element : s.createQuery("from " + Departments.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testDynamicBoosts() throws Exception {
        Session session = this.openSession();
        session.beginTransaction();
        DynamicBoostedDescLibrary lib1 = new DynamicBoostedDescLibrary();
        lib1.setName("one");
        session.persist((Object)lib1);
        DynamicBoostedDescLibrary lib2 = new DynamicBoostedDescLibrary();
        lib2.setName("two");
        session.persist((Object)lib2);
        session.getTransaction().commit();
        session.close();
        float lib1Score = this.getScore((Query)new TermQuery(new Term("name", "one")));
        float lib2Score = this.getScore((Query)new TermQuery(new Term("name", "two")));
        Assert.assertEquals((String)"The scores should be equal", (float)lib1Score, (float)lib2Score, (float)0.0f);
        session = this.openSession();
        session.beginTransaction();
        session.refresh((Object)lib2);
        lib2.setDynScore(2.0f);
        session.getTransaction().commit();
        session.close();
        lib1Score = this.getScore((Query)new TermQuery(new Term("name", "one")));
        lib2Score = this.getScore((Query)new TermQuery(new Term("name", "two")));
        Assert.assertTrue((String)"lib2score should be greater than lib1score", (lib1Score < lib2Score ? 1 : 0) != 0);
        lib1Score = this.getScore((Query)new TermQuery(new Term("name", "foobar")));
        Assert.assertEquals((String)"lib1score should be 0 since term is not yet indexed.", (float)0.0f, (float)lib1Score, (float)0.0f);
        session = this.openSession();
        session.beginTransaction();
        session.refresh((Object)lib1);
        lib1.setName("foobar");
        session.getTransaction().commit();
        session.close();
        lib1Score = this.getScore((Query)new TermQuery(new Term("name", "foobar")));
        lib2Score = this.getScore((Query)new TermQuery(new Term("name", "two")));
        Assert.assertTrue((String)"lib1score should be greater than lib2score", (lib1Score > lib2Score ? 1 : 0) != 0);
    }

    @Test
    public void testSpatial() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        MemberLevelTestPoI memberLevelTestPoI = new MemberLevelTestPoI("test", 24.0, 32.0);
        s.persist((Object)memberLevelTestPoI);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryBuilder builder = session.getSearchFactory().buildQueryBuilder().forEntity(MemberLevelTestPoI.class).get();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        Query luceneQuery = builder.spatial().onField("location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = session.createFullTextQuery(luceneQuery, new Class[]{MemberLevelTestPoI.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onField("location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = session.createFullTextQuery(luceneQuery2, new Class[]{MemberLevelTestPoI.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        List testPoIs = session.createQuery("from " + MemberLevelTestPoI.class.getName()).list();
        for (Object entity : testPoIs) {
            session.delete(entity);
        }
        tx.commit();
        session.close();
        s = this.openSession();
        tx = s.beginTransaction();
        ClassLevelTestPoI classLevelTestPoI = new ClassLevelTestPoI("test", 24.0, 32.0);
        s.persist((Object)classLevelTestPoI);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        session = Search.getFullTextSession((Session)s);
        builder = session.getSearchFactory().buildQueryBuilder().forEntity(ClassLevelTestPoI.class).get();
        centerLatitude = 24.0;
        centerLongitude = 31.5;
        luceneQuery = SpatialQueryBuilder.buildSpatialQueryByHash((double)centerLatitude, (double)centerLongitude, (double)50.0, (String)"location");
        hibQuery = session.createFullTextQuery(luceneQuery, new Class[]{ClassLevelTestPoI.class});
        results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        luceneQuery2 = SpatialQueryBuilder.buildSpatialQueryByHash((double)centerLatitude, (double)centerLongitude, (double)51.0, (String)"location");
        hibQuery2 = session.createFullTextQuery(luceneQuery2, new Class[]{ClassLevelTestPoI.class});
        results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        testPoIs = session.createQuery("from " + ClassLevelTestPoI.class.getName()).list();
        for (Object entity : testPoIs) {
            session.delete(entity);
        }
        tx.commit();
        session.close();
        s = this.openSession();
        tx = s.beginTransaction();
        LatLongAnnTestPoi latLongAnnTestPoi = new LatLongAnnTestPoi("test", 24.0, 32.0);
        s.persist((Object)latLongAnnTestPoi);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        session = Search.getFullTextSession((Session)s);
        builder = session.getSearchFactory().buildQueryBuilder().forEntity(LatLongAnnTestPoi.class).get();
        centerLatitude = 24.0;
        centerLongitude = 31.5;
        luceneQuery = builder.spatial().onField("location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        hibQuery = session.createFullTextQuery(luceneQuery, new Class[]{LatLongAnnTestPoi.class});
        results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        luceneQuery2 = builder.spatial().onField("location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        hibQuery2 = session.createFullTextQuery(luceneQuery2, new Class[]{LatLongAnnTestPoi.class});
        results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        testPoIs = session.createQuery("from " + LatLongAnnTestPoi.class.getName()).list();
        for (Object entity : testPoIs) {
            session.delete(entity);
        }
        tx.commit();
        session.close();
    }

    @Test
    public void testClassBridgeInstanceMapping() throws Exception {
        OrderLine orderLine = new OrderLine();
        orderLine.setName("Sequoia");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)orderLine);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("orderLineName:Sequoia");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        Assert.assertEquals((String)"Bridge not used", (long)1L, (long)query.getResultSize());
        luceneQuery = parser.parse("orderLineName_ngram:quo");
        query = s.createFullTextQuery(luceneQuery, new Class[0]);
        Assert.assertEquals((String)"Analyzer configuration not applied", (long)1L, (long)query.getResultSize());
        luceneQuery = parser.parse("orderLineNameViaParam:Sequoia");
        query = s.createFullTextQuery(luceneQuery, new Class[0]);
        Assert.assertEquals((String)"Parameter configuration not applied", (long)1L, (long)query.getResultSize());
        s.delete(query.list().get(0));
        tx.commit();
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getScore(Query query) {
        float score;
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            List resultList = fullTextSession.createFullTextQuery(query, new Class[]{DynamicBoostedDescLibrary.class}).setProjection(new String[]{"__HSearch_Score", "__HSearch_Explanation"}).setMaxResults(1).list();
            if (resultList.size() == 0) {
                score = 0.0f;
            } else {
                Object[] queryResult = (Object[])resultList.get(0);
                score = ((Float)queryResult[0]).floatValue();
                String explanation = queryResult[1].toString();
                log.debugf("score: %f explanation: %s", (Object)Float.valueOf(score), (Object)explanation);
            }
        }
        return score;
    }

    private int nbrOfMatchingResults(String field, String token, FullTextSession s) throws ParseException {
        QueryParser parser = new QueryParser(field, TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse(token);
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        return query.getResultSize();
    }

    private Departments getDepts1() {
        Departments depts = new Departments();
        depts.setBranch("Salt Lake City");
        depts.setBranchHead("Kent Lewin");
        depts.setMaxEmployees(100);
        depts.setNetwork("1A");
        depts.setManufacturer("C");
        return depts;
    }

    private Departments getDepts2() {
        Departments depts = new Departments();
        depts.setBranch("Layton");
        depts.setBranchHead("Terry Poperszky");
        depts.setMaxEmployees(20);
        depts.setNetwork("2B");
        depts.setManufacturer("3");
        return depts;
    }

    private Departments getDepts3() {
        Departments depts = new Departments();
        depts.setBranch("West Valley");
        depts.setBranchHead("Pat Kelley");
        depts.setMaxEmployees(15);
        depts.setNetwork("3C");
        depts.setManufacturer("D");
        return depts;
    }

    private Departments getDepts4() {
        Departments depts = new Departments();
        depts.setBranch("St. George");
        depts.setBranchHead("Spencer Stajskal");
        depts.setMaxEmployees(10);
        depts.setNetwork("1D");
        depts.setManufacturer("C");
        return depts;
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.model_mapping", ProgrammaticSearchMappingFactory.class.getName());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Address.class, Country.class, BlogEntry.class, ProvidedIdEntry.class, ProductCatalog.class, Item.class, Departments.class, DynamicBoostedDescLibrary.class, MemberLevelTestPoI.class, ClassLevelTestPoI.class, LatLongAnnTestPoi.class, OrderLine.class};
    }
}

