/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.objectloading.mixedhierarchy;

import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.objectloading.mixedhierarchy.College;
import org.hibernate.search.test.query.objectloading.mixedhierarchy.CommunityCollege;
import org.hibernate.search.test.query.objectloading.mixedhierarchy.EducationalInstitution;
import org.hibernate.search.test.query.objectloading.mixedhierarchy.HighSchool;
import org.hibernate.search.test.query.objectloading.mixedhierarchy.PrimarySchool;
import org.hibernate.search.test.query.objectloading.mixedhierarchy.School;
import org.hibernate.search.test.query.objectloading.mixedhierarchy.University;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ObjectLoadingCrossHierarchyTest
extends SearchTestBase {
    private FullTextSession fullTextSession;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.indexTestData();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1793")
    public void testQueryingForEntitiesFromDifferentIdSpaces() throws Exception {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(EducationalInstitution.class).get();
        Query query = queryBuilder.bool().should(queryBuilder.keyword().onField("name").matching((Object)"Southern Florida College of Golf").createQuery()).should(queryBuilder.keyword().onField("name").matching((Object)"St. Lucie Community College").createQuery()).should(queryBuilder.keyword().onField("name").matching((Object)"Wogharts").createQuery()).should(queryBuilder.keyword().onField("name").matching((Object)"Homestead Elementary School").createQuery()).should(queryBuilder.keyword().onField("name").matching((Object)"Cutler Bay High School").createQuery()).createQuery();
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{EducationalInstitution.class}).list();
        ((ListAssert)Assertions.assertThat((List)results).onProperty("name").describedAs("Can load results originating from different id spaces, using different id types and names")).containsOnly(new Object[]{"Southern Florida College of Golf", "Wogharts", "St. Lucie Community College", "Homestead Elementary School", "Cutler Bay High School"});
    }

    private void indexTestData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        University wogharts = new University(1, "Wogharts");
        this.fullTextSession.persist((Object)wogharts);
        College golfCollege = new College(1L, "Southern Florida College of Golf");
        this.fullTextSession.persist((Object)golfCollege);
        CommunityCollege stLucieCommunityCollege = new CommunityCollege(2L, "St. Lucie Community College");
        this.fullTextSession.persist((Object)stLucieCommunityCollege);
        PrimarySchool homesteadPrimary = new PrimarySchool(1, "Homestead Elementary School");
        this.fullTextSession.persist((Object)homesteadPrimary);
        HighSchool cutlerBayHigh = new HighSchool(1L, "Cutler Bay High School");
        this.fullTextSession.persist((Object)cutlerBayHigh);
        tx.commit();
        this.fullTextSession.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{EducationalInstitution.class, University.class, College.class, CommunityCollege.class, School.class, PrimarySchool.class, HighSchool.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.query.database_retrieval_method", "query");
    }
}

