/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.Utf8;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.fest.assertions.ObjectAssert;
import org.hibernate.search.test.serialization.AvroUtils;
import org.junit.Test;

public class AvroTest {
    @Test
    public void experimentWithAvro() throws Exception {
        String root = "org/hibernate/search/remote/codex/avro/v1_0/";
        AvroUtils.parseSchema(root + "attribute/TokenTrackingAttribute.avro", "attribute/TokenTrackingAttribute");
        AvroUtils.parseSchema(root + "attribute/CharTermAttribute.avro", "attribute/CharTermAttribute");
        AvroUtils.parseSchema(root + "attribute/PayloadAttribute.avro", "attribute/PayloadAttribute");
        AvroUtils.parseSchema(root + "attribute/KeywordAttribute.avro", "attribute/KeywordAttribute");
        AvroUtils.parseSchema(root + "attribute/PositionIncrementAttribute.avro", "attribute/PositionIncrementAttribute");
        AvroUtils.parseSchema(root + "attribute/FlagsAttribute.avro", "attribute/FlagsAttribute");
        AvroUtils.parseSchema(root + "attribute/TypeAttribute.avro", "attribute/TypeAttribute");
        AvroUtils.parseSchema(root + "attribute/OffsetAttribute.avro", "attribute/OffsetAttribute");
        AvroUtils.parseSchema(root + "field/TermVector.avro", "field/TermVector");
        AvroUtils.parseSchema(root + "field/Index.avro", "field/Index");
        AvroUtils.parseSchema(root + "field/Store.avro", "field/Store");
        AvroUtils.parseSchema(root + "field/TokenStreamField.avro", "field/TokenStreamField");
        AvroUtils.parseSchema(root + "field/ReaderField.avro", "field/ReaderField");
        AvroUtils.parseSchema(root + "field/StringField.avro", "field/StringField");
        AvroUtils.parseSchema(root + "field/BinaryField.avro", "field/BinaryField");
        AvroUtils.parseSchema(root + "field/NumericIntField.avro", "field/NumericIntField");
        AvroUtils.parseSchema(root + "field/NumericLongField.avro", "field/NumericLongField");
        AvroUtils.parseSchema(root + "field/NumericFloatField.avro", "field/NumericFloatField");
        AvroUtils.parseSchema(root + "field/NumericDoubleField.avro", "field/NumericDoubleField");
        AvroUtils.parseSchema(root + "field/CustomFieldable.avro", "field/CustomFieldable");
        AvroUtils.parseSchema(root + "Document.avro", "Document");
        AvroUtils.parseSchema(root + "operation/Id.avro", "operation/Id");
        AvroUtils.parseSchema(root + "operation/OptimizeAll.avro", "operation/OptimizeAll");
        AvroUtils.parseSchema(root + "operation/PurgeAll.avro", "operation/PurgeAll");
        AvroUtils.parseSchema(root + "operation/Delete.avro", "operation/Delete");
        AvroUtils.parseSchema(root + "operation/Add.avro", "operation/Add");
        AvroUtils.parseSchema(root + "operation/Update.avro", "operation/Update");
        AvroUtils.parseSchema(root + "Message.avro", "Message");
        String filename = root + "Works.avpr";
        Protocol protocol = AvroUtils.parseProtocol(filename, "Works");
        Schema termVectorSchema = protocol.getType("TermVector");
        Schema indexSchema = protocol.getType("Index");
        Schema storeSchema = protocol.getType("Store");
        Schema tokenTrackingAttribute = protocol.getType("TokenTrackingAttribute");
        Schema tokenStreamSchema = protocol.getType("TokenStreamField");
        Schema readerSchema = protocol.getType("ReaderField");
        Schema stringSchema = protocol.getType("StringField");
        Schema binarySchema = protocol.getType("BinaryField");
        Schema intFieldSchema = protocol.getType("NumericIntField");
        Schema longFieldSchema = protocol.getType("NumericLongField");
        Schema floatFieldSchema = protocol.getType("NumericFloatField");
        Schema doubleFieldSchema = protocol.getType("NumericDoubleField");
        Schema custonFieldableSchema = protocol.getType("CustomFieldable");
        Schema documentSchema = protocol.getType("Document");
        Schema idSchema = protocol.getType("Id");
        Schema optimizeAllSchema = protocol.getType("OptimizeAll");
        Schema purgeAllSchema = protocol.getType("PurgeAll");
        Schema deleteSchema = protocol.getType("Delete");
        Schema addSchema = protocol.getType("Add");
        Schema updateSchema = protocol.getType("Update");
        Schema messageSchema = protocol.getType("Message");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GenericDatumWriter writer = new GenericDatumWriter(messageSchema);
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
        byte[] serializableSample = new byte[10];
        for (int i = 0; i < 10; ++i) {
            serializableSample[i] = (byte)i;
        }
        ArrayList<String> classReferences = new ArrayList<String>();
        classReferences.add(AvroTest.class.getName());
        ArrayList<Object> fieldables = new ArrayList<Object>(1);
        GenericData.Record customFieldable = new GenericData.Record(custonFieldableSchema);
        customFieldable.put("instance", (Object)ByteBuffer.wrap(serializableSample));
        fieldables.add(customFieldable);
        GenericRecord numericField = this.createNumeric(intFieldSchema);
        numericField.put("value", (Object)3);
        fieldables.add(numericField);
        numericField = this.createNumeric(longFieldSchema);
        numericField.put("value", (Object)3L);
        fieldables.add(numericField);
        numericField = this.createNumeric(floatFieldSchema);
        numericField.put("value", (Object)Float.valueOf(2.3f));
        fieldables.add(numericField);
        numericField = this.createNumeric(doubleFieldSchema);
        numericField.put("value", (Object)2.3);
        fieldables.add(numericField);
        GenericRecord field = this.createField(binarySchema);
        field.put("offset", (Object)0);
        field.put("length", (Object)10);
        field.put("value", (Object)ByteBuffer.wrap(serializableSample));
        fieldables.add(field);
        field = this.createField(stringSchema);
        field.put("value", (Object)stringSchema.getName());
        field.put("store", (Object)"YES");
        field.put("index", (Object)"ANALYZED");
        field.put("termVector", (Object)"WITH_OFFSETS");
        fieldables.add(field);
        field = this.createField(tokenStreamSchema);
        ArrayList tokens = new ArrayList();
        ArrayList<Object> attrs = new ArrayList<Object>();
        tokens.add(attrs);
        GenericData.Record attr = new GenericData.Record(tokenTrackingAttribute);
        ArrayList<Integer> positions = new ArrayList<Integer>();
        positions.add(1);
        positions.add(2);
        positions.add(3);
        positions.add(4);
        attr.put("positions", positions);
        attrs.add(attr);
        attrs.add(ByteBuffer.wrap(serializableSample));
        field.put("value", tokens);
        field.put("termVector", (Object)"WITH_OFFSETS");
        fieldables.add(field);
        field = this.createField(readerSchema);
        field.put("value", (Object)ByteBuffer.wrap(serializableSample));
        field.put("termVector", (Object)"WITH_OFFSETS");
        fieldables.add(field);
        GenericData.Record doc = new GenericData.Record(documentSchema);
        doc.put("boost", (Object)Float.valueOf(2.3f));
        doc.put("fieldables", fieldables);
        GenericData.Record add = new GenericData.Record(addSchema);
        add.put("class", (Object)classReferences.indexOf(AvroTest.class.getName()));
        GenericData.Record id = new GenericData.Record(idSchema);
        id.put("value", (Object)ByteBuffer.wrap(serializableSample));
        add.put("id", (Object)id);
        add.put("document", (Object)doc);
        HashMap<String, String> analyzers = new HashMap<String, String>();
        analyzers.put("name", "ngram");
        analyzers.put("description", "porter");
        add.put("fieldToAnalyzerMap", analyzers);
        GenericData.Record delete = new GenericData.Record(deleteSchema);
        delete.put("class", (Object)classReferences.indexOf(AvroTest.class.getName()));
        id = new GenericData.Record(idSchema);
        id.put("value", (Object)new Long(30L));
        delete.put("id", (Object)id);
        GenericData.Record purgeAll = new GenericData.Record(purgeAllSchema);
        purgeAll.put("class", (Object)classReferences.indexOf(AvroTest.class.getName()));
        GenericData.Record optimizeAll = new GenericData.Record(optimizeAllSchema);
        ArrayList<GenericData.Record> operations = new ArrayList<GenericData.Record>(1);
        operations.add(purgeAll);
        operations.add(optimizeAll);
        operations.add(delete);
        operations.add(add);
        GenericData.Record message = new GenericData.Record(messageSchema);
        message.put("classReferences", classReferences);
        message.put("operations", operations);
        writer.write((Object)message, (Encoder)encoder);
        encoder.flush();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)inputStream, null);
        GenericDatumReader reader = new GenericDatumReader(messageSchema);
        try {
            while (true) {
                GenericRecord result = (GenericRecord)reader.read(null, (Decoder)decoder);
                System.out.println(result);
                Assertions.assertThat((Object)result).isNotNull();
                ((ObjectAssert)Assertions.assertThat((Object)result.get("operations")).isNotNull()).isInstanceOf(List.class);
                List ops = (List)result.get("operations");
                Assertions.assertThat((List)ops).hasSize(4);
                Assertions.assertThat(ops.get(2)).isInstanceOf(GenericRecord.class);
                GenericRecord deleteOp = (GenericRecord)ops.get(2);
                Assertions.assertThat((String)deleteOp.getSchema().getName()).isEqualTo((Object)"Delete");
                Object actual = ((GenericRecord)deleteOp.get("id")).get("value");
                Assertions.assertThat((Object)actual).isInstanceOf(Long.class);
                Assertions.assertThat((Object)actual).isEqualTo((Object)30L);
                Assertions.assertThat(ops.get(3)).isInstanceOf(GenericRecord.class);
                GenericRecord addOp = (GenericRecord)ops.get(3);
                Assertions.assertThat((String)addOp.getSchema().getName()).isEqualTo((Object)"Add");
                actual = ((GenericRecord)addOp.get("id")).get("value");
                Assertions.assertThat((Object)actual).isInstanceOf(ByteBuffer.class);
                ByteBuffer bb = (ByteBuffer)actual;
                Assertions.assertThat((boolean)bb.hasArray()).isTrue();
                byte[] copy = new byte[bb.remaining()];
                bb.get(copy);
                Assertions.assertThat((byte[])serializableSample).isEqualTo(copy);
                Assertions.assertThat((Object)addOp.get("fieldToAnalyzerMap")).isInstanceOf(Map.class);
                Assertions.assertThat((Map)((Map)addOp.get("fieldToAnalyzerMap"))).hasSize(2);
                Assertions.assertThat((Object)addOp.get("document")).isNotNull();
                GenericRecord document = (GenericRecord)addOp.get("document");
                Assertions.assertThat((Object)document.get("boost")).isEqualTo((Object)Float.valueOf(2.3f));
                ((ObjectAssert)Assertions.assertThat((Object)document.get("fieldables")).isNotNull()).isInstanceOf(List.class);
                List fields = (List)document.get("fieldables");
                Assertions.assertThat((List)fields).hasSize(9);
                field = (GenericRecord)fields.get(0);
                Assertions.assertThat((String)field.getSchema().getName()).isEqualTo((Object)"CustomFieldable");
                field = (GenericRecord)fields.get(1);
                Assertions.assertThat((String)field.getSchema().getName()).isEqualTo((Object)"NumericIntField");
                Assertions.assertThat((Object)field.get("value")).isEqualTo((Object)3);
                this.assertNumericField(field);
                field = (GenericRecord)fields.get(2);
                Assertions.assertThat((String)field.getSchema().getName()).isEqualTo((Object)"NumericLongField");
                Assertions.assertThat((Object)field.get("value")).isEqualTo((Object)3L);
                this.assertNumericField(field);
                field = (GenericRecord)fields.get(3);
                Assertions.assertThat((String)field.getSchema().getName()).isEqualTo((Object)"NumericFloatField");
                Assertions.assertThat((Object)field.get("value")).isEqualTo((Object)Float.valueOf(2.3f));
                this.assertNumericField(field);
                field = (GenericRecord)fields.get(4);
                Assertions.assertThat((String)field.getSchema().getName()).isEqualTo((Object)"NumericDoubleField");
                Assertions.assertThat((Object)field.get("value")).isEqualTo((Object)2.3);
                this.assertNumericField(field);
                field = (GenericRecord)fields.get(5);
                Assertions.assertThat((String)field.getSchema().getName()).isEqualTo((Object)"BinaryField");
                Assertions.assertThat((Object)field.get("value")).isInstanceOf(ByteBuffer.class);
                this.assertField(field);
                field = (GenericRecord)fields.get(6);
                Assertions.assertThat((String)field.getSchema().getName()).isEqualTo((Object)"StringField");
                Assertions.assertThat((Object)field.get("value")).isInstanceOf(Utf8.class);
                this.assertTermVector(field);
                this.assertIndexAndStore(field);
                this.assertField(field);
                field = (GenericRecord)fields.get(7);
                Assertions.assertThat((String)field.getSchema().getName()).isEqualTo((Object)"TokenStreamField");
                Assertions.assertThat((Object)field.get("value")).isInstanceOf(List.class);
                List l1 = (List)field.get("value");
                ((ListAssert)Assertions.assertThat((List)((List)l1.get(0))).as("Wrong attribute impl list")).hasSize(2);
                Object object = ((List)l1.get(0)).get(0);
                Assertions.assertThat(object).isNotNull();
                this.assertTermVector(field);
                this.assertField(field);
                field = (GenericRecord)fields.get(8);
                Assertions.assertThat((String)field.getSchema().getName()).isEqualTo((Object)"ReaderField");
                Assertions.assertThat((Object)field.get("value")).isInstanceOf(ByteBuffer.class);
                this.assertTermVector(field);
                this.assertField(field);
            }
        }
        catch (EOFException eof) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private void assertTermVector(GenericRecord field) {
        Assertions.assertThat((Object)field.get("termVector")).isInstanceOf(GenericEnumSymbol.class);
        Assertions.assertThat((String)field.get("termVector").toString()).isEqualTo((Object)"WITH_OFFSETS");
    }

    private void assertIndexAndStore(GenericRecord field) {
        Assertions.assertThat((Object)field.get("index")).isInstanceOf(GenericEnumSymbol.class);
        Assertions.assertThat((String)field.get("index").toString()).isEqualTo((Object)"ANALYZED");
        Assertions.assertThat((Object)field.get("store")).isInstanceOf(GenericEnumSymbol.class);
        Assertions.assertThat((String)field.get("store").toString()).isEqualTo((Object)"YES");
    }

    private void assertField(GenericRecord field) {
        Assertions.assertThat((Object)field.get("name")).isInstanceOf(Utf8.class);
        Assertions.assertThat((String)field.get("name").toString()).isEqualTo((Object)field.getSchema().getName());
        Assertions.assertThat((Object)field.get("boost")).isEqualTo((Object)Float.valueOf(2.3f));
        Assertions.assertThat((Object)field.get("omitNorms")).isEqualTo((Object)true);
        Assertions.assertThat((Object)field.get("omitTermFreqAndPositions")).isEqualTo((Object)true);
    }

    private GenericRecord createField(Schema schema) {
        GenericData.Record field = new GenericData.Record(schema);
        field.put("name", (Object)schema.getName());
        field.put("boost", (Object)Float.valueOf(2.3f));
        field.put("omitNorms", (Object)true);
        field.put("omitTermFreqAndPositions", (Object)true);
        return field;
    }

    private void assertNumericField(GenericRecord field) {
        Assertions.assertThat((Object)field.get("name")).isInstanceOf(Utf8.class);
        Assertions.assertThat((String)field.get("name").toString()).isEqualTo((Object)"int");
        Assertions.assertThat((Object)field.get("precisionStep")).isEqualTo((Object)3);
        Assertions.assertThat((Object)field.get("boost")).isEqualTo((Object)Float.valueOf(2.3f));
        Assertions.assertThat((Object)field.get("indexed")).isEqualTo((Object)true);
        Assertions.assertThat((Object)field.get("omitNorms")).isEqualTo((Object)true);
        Assertions.assertThat((Object)field.get("omitTermFreqAndPositions")).isEqualTo((Object)true);
        Assertions.assertThat((Object)field.get("store")).isInstanceOf(GenericData.EnumSymbol.class);
        Assertions.assertThat((String)field.get("store").toString()).isEqualTo((Object)"YES");
    }

    private GenericRecord createNumeric(Schema schema) {
        GenericData.Record numericField = new GenericData.Record(schema);
        numericField.put("name", (Object)"int");
        numericField.put("precisionStep", (Object)3);
        numericField.put("store", (Object)"YES");
        numericField.put("indexed", (Object)true);
        numericField.put("boost", (Object)Float.valueOf(2.3f));
        numericField.put("omitNorms", (Object)true);
        numericField.put("omitTermFreqAndPositions", (Object)true);
        return numericField;
    }
}

