/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.serialization;

import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.serialization.avro.impl.AvroSerializationProvider;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.serialization.spi.SerializationProvider;
import org.hibernate.search.test.serialization.RemoteEntity;
import org.hibernate.search.test.serialization.SerializationTest;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.concurrency.ConcurrentRunner;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1637")
public class ConcurrentServiceTest {
    @Rule
    public SearchFactoryHolder searchFactoryHolder = new SearchFactoryHolder(new Class[]{RemoteEntity.class});

    @Test
    public void verifyAvroSerializerInUse() {
        SerializationProvider serializationProvider = (SerializationProvider)this.searchFactoryHolder.getSearchFactory().getServiceManager().requestService(SerializationProvider.class);
        Assert.assertTrue((String)"Wrong serialization provider", (boolean)(serializationProvider instanceof AvroSerializationProvider));
    }

    @Test
    public void concurrentSerialization() throws Exception {
        final LuceneWorkSerializer serializer = this.extractSerializer();
        final List<LuceneWork> works = SerializationTest.buildWorks();
        ConcurrentRunner runner = new ConcurrentRunner(new ConcurrentRunner.TaskFactory(){

            public Runnable createRunnable(int i) throws Exception {
                return new SerializingThread(serializer, works);
            }
        });
        runner.execute();
    }

    @Test
    public void concurrentDeserialization() throws Exception {
        final LuceneWorkSerializer serializer = this.extractSerializer();
        final byte[] serializedModel = serializer.toSerializedModel(SerializationTest.buildWorks());
        ConcurrentRunner runner = new ConcurrentRunner(new ConcurrentRunner.TaskFactory(){

            public Runnable createRunnable(int i) throws Exception {
                return new DeserializingThread(serializer, serializedModel);
            }
        });
        runner.execute();
    }

    private LuceneWorkSerializer extractSerializer() {
        return this.searchFactoryHolder.getSearchFactory().getIndexManagerHolder().getIndexManager(RemoteEntity.class.getName()).getSerializer();
    }

    private static class DeserializingThread
    implements Runnable {
        private final LuceneWorkSerializer serializer;
        private final byte[] serializedModel;

        public DeserializingThread(LuceneWorkSerializer serializer, byte[] serializedModel) {
            this.serializer = serializer;
            this.serializedModel = serializedModel;
        }

        @Override
        public void run() {
            this.serializer.toLuceneWorks(this.serializedModel);
        }
    }

    private static class SerializingThread
    implements Runnable {
        private final LuceneWorkSerializer serializer;
        private final List<LuceneWork> workList;

        public SerializingThread(LuceneWorkSerializer serializer, List<LuceneWork> workList) {
            this.serializer = serializer;
            this.workList = workList;
        }

        @Override
        public void run() {
            this.serializer.toSerializedModel(this.workList);
        }
    }
}

