/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.serialization;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttributeImpl;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.BytesRef;
import org.fest.assertions.Assertions;
import org.fest.assertions.MapAssert;
import org.fest.assertions.ObjectAssert;
import org.fest.assertions.StringAssert;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.indexes.serialization.impl.CopyTokenStream;
import org.hibernate.search.indexes.serialization.spi.SerializableTokenStream;
import org.junit.Assert;

final class AvroTestHelpers {
    private AvroTestHelpers() {
    }

    static List<List<AttributeImpl>> buildTokenSteamWithAttributes() {
        ArrayList<List<AttributeImpl>> tokens = new ArrayList<List<AttributeImpl>>();
        tokens.add(new ArrayList());
        CharTermAttributeImpl charAttr = new CharTermAttributeImpl();
        charAttr.append("Wazzza");
        ((List)tokens.get(0)).add(charAttr);
        PayloadAttributeImpl payloadAttribute = new PayloadAttributeImpl();
        payloadAttribute.setPayload(new BytesRef(new byte[]{0, 1, 2, 3}));
        ((List)tokens.get(0)).add(payloadAttribute);
        KeywordAttributeImpl keywordAttr = new KeywordAttributeImpl();
        keywordAttr.setKeyword(true);
        ((List)tokens.get(0)).add(keywordAttr);
        PositionIncrementAttributeImpl posIncrAttr = new PositionIncrementAttributeImpl();
        posIncrAttr.setPositionIncrement(3);
        ((List)tokens.get(0)).add(posIncrAttr);
        FlagsAttributeImpl flagsAttr = new FlagsAttributeImpl();
        flagsAttr.setFlags(435);
        ((List)tokens.get(0)).add(flagsAttr);
        TypeAttributeImpl typeAttr = new TypeAttributeImpl();
        typeAttr.setType("acronym");
        ((List)tokens.get(0)).add(typeAttr);
        OffsetAttributeImpl offsetAttr = new OffsetAttributeImpl();
        offsetAttr.setOffset(4, 7);
        ((List)tokens.get(0)).add(offsetAttr);
        return tokens;
    }

    static void assertLuceneWork(LuceneWork work, LuceneWork copy) {
        Assertions.assertThat((Object)copy).isInstanceOf(work.getClass());
        if (work instanceof OptimizeLuceneWork) {
            Assert.assertNotNull((Object)copy);
            Assert.assertTrue((boolean)(copy instanceof OptimizeLuceneWork));
        } else if (work instanceof PurgeAllLuceneWork) {
            AvroTestHelpers.assertPurgeAll((PurgeAllLuceneWork)work, (PurgeAllLuceneWork)copy);
        } else if (work instanceof DeleteLuceneWork) {
            AvroTestHelpers.assertDelete((DeleteLuceneWork)work, (DeleteLuceneWork)copy);
        } else if (work instanceof AddLuceneWork) {
            AvroTestHelpers.assertAdd((AddLuceneWork)work, (AddLuceneWork)copy);
        } else if (work instanceof UpdateLuceneWork) {
            AvroTestHelpers.assertUpdate((UpdateLuceneWork)work, (UpdateLuceneWork)copy);
        } else {
            Assert.fail((String)"unexpected type");
        }
    }

    private static void assertAdd(AddLuceneWork work, AddLuceneWork copy) {
        ((ObjectAssert)Assertions.assertThat((Object)work.getEntityClass()).as("Add.getEntityClass is not copied")).isEqualTo((Object)copy.getEntityClass());
        ((ObjectAssert)Assertions.assertThat((Object)work.getId()).as("Add.getId is not copied")).isEqualTo((Object)copy.getId());
        ((StringAssert)Assertions.assertThat((String)work.getIdInString()).as("Add.getIdInString is not the same")).isEqualTo((Object)copy.getIdInString());
        ((MapAssert)Assertions.assertThat((Map)work.getFieldToAnalyzerMap()).as("Add.getFieldToAnalyzerMap is not the same")).isEqualTo((Object)copy.getFieldToAnalyzerMap());
        AvroTestHelpers.assertDocument(work.getDocument(), copy.getDocument());
    }

    private static void assertUpdate(UpdateLuceneWork work, UpdateLuceneWork copy) {
        ((ObjectAssert)Assertions.assertThat((Object)work.getEntityClass()).as("Add.getEntityClass is not copied")).isEqualTo((Object)copy.getEntityClass());
        ((ObjectAssert)Assertions.assertThat((Object)work.getId()).as("Add.getId is not copied")).isEqualTo((Object)copy.getId());
        ((StringAssert)Assertions.assertThat((String)work.getIdInString()).as("Add.getIdInString is not the same")).isEqualTo((Object)copy.getIdInString());
        ((MapAssert)Assertions.assertThat((Map)work.getFieldToAnalyzerMap()).as("Add.getFieldToAnalyzerMap is not the same")).isEqualTo((Object)copy.getFieldToAnalyzerMap());
        AvroTestHelpers.assertDocument(work.getDocument(), copy.getDocument());
    }

    private static void assertDocument(Document original, Document copy) {
        Assertions.assertThat((int)original.getFields().size()).isEqualTo(copy.getFields().size());
        for (int index = 0; index < original.getFields().size(); ++index) {
            IndexableField field = (IndexableField)original.getFields().get(index);
            IndexableField fieldCopy = (IndexableField)copy.getFields().get(index);
            AvroTestHelpers.assertFieldEquality((Field)field, (Field)fieldCopy);
        }
    }

    private static void assertFieldEquality(Field original, Field copy) {
        Assertions.assertThat((String)copy.name()).isEqualTo((Object)original.name());
        Assertions.assertThat((Object)copy.binaryValue()).isEqualTo((Object)original.binaryValue());
        Assertions.assertThat((float)copy.boost()).isEqualTo(original.boost());
        AvroTestHelpers.assertFieldType(copy.fieldType(), original.fieldType());
        Assertions.assertThat((boolean)AvroTestHelpers.compareReaders(copy.readerValue(), original.readerValue())).isTrue();
        Assertions.assertThat((boolean)AvroTestHelpers.compareTokenStreams(original.tokenStreamValue(), copy.tokenStreamValue())).isTrue();
        Assertions.assertThat((String)copy.stringValue()).isEqualTo((Object)original.stringValue());
    }

    private static void assertFieldType(FieldType copy, FieldType original) {
        Assertions.assertThat((boolean)original.omitNorms()).isEqualTo(copy.omitNorms());
        Assertions.assertThat((boolean)original.storeTermVectorOffsets()).isEqualTo(copy.storeTermVectorOffsets());
        Assertions.assertThat((boolean)original.storeTermVectorPayloads()).isEqualTo(copy.storeTermVectorPayloads());
        Assertions.assertThat((boolean)original.storeTermVectorOffsets()).isEqualTo(copy.storeTermVectorOffsets());
        Assertions.assertThat((Object)original.docValueType()).isEqualTo((Object)copy.docValueType());
        Assertions.assertThat((boolean)original.indexed()).isEqualTo(copy.indexed());
        Assertions.assertThat((Object)original.indexOptions()).isEqualTo((Object)copy.indexOptions());
        Assertions.assertThat((int)original.numericPrecisionStep()).isEqualTo(copy.numericPrecisionStep());
        Assertions.assertThat((Object)original.numericType()).isEqualTo((Object)copy.numericType());
        Assertions.assertThat((boolean)original.stored()).isEqualTo(copy.stored());
        Assertions.assertThat((boolean)original.storeTermVectors()).isEqualTo(copy.storeTermVectors());
        Assertions.assertThat((boolean)original.tokenized()).isEqualTo(copy.tokenized());
        Assertions.assertThat((String)original.toString()).isEqualTo((Object)copy.toString());
    }

    private static boolean compareTokenStreams(TokenStream original, TokenStream copy) {
        if (original == null) {
            return copy == null;
        }
        try {
            original.reset();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SerializableTokenStream serOriginal = CopyTokenStream.buildSerializabletokenStream((TokenStream)original);
        SerializableTokenStream serCopy = CopyTokenStream.buildSerializabletokenStream((TokenStream)copy);
        if (serOriginal.getStream().size() != serCopy.getStream().size()) {
            return false;
        }
        for (int i = 0; i < serOriginal.getStream().size(); ++i) {
            List origToken = (List)serOriginal.getStream().get(i);
            List copyToken = (List)serCopy.getStream().get(i);
            if (origToken.size() != copyToken.size()) {
                return false;
            }
            for (int j = 0; j < origToken.size(); ++j) {
                AttributeImpl origAttr = (AttributeImpl)origToken.get(j);
                AttributeImpl copyAttr = (AttributeImpl)copyToken.get(j);
                if (origAttr.getClass() != copyAttr.getClass()) {
                    return false;
                }
                AvroTestHelpers.testAttributeTypes(origAttr, copyAttr);
            }
        }
        return true;
    }

    private static void testAttributeTypes(AttributeImpl origAttr, AttributeImpl copyAttr) {
        if (origAttr instanceof CharTermAttribute) {
            Assertions.assertThat((String)origAttr.toString()).isEqualTo((Object)copyAttr.toString());
        } else if (origAttr instanceof PayloadAttribute) {
            Assertions.assertThat((Object)((PayloadAttribute)origAttr).getPayload()).isEqualTo((Object)((PayloadAttribute)copyAttr).getPayload());
        } else if (origAttr instanceof KeywordAttribute) {
            Assertions.assertThat((boolean)((KeywordAttribute)origAttr).isKeyword()).isEqualTo(((KeywordAttribute)copyAttr).isKeyword());
        } else if (origAttr instanceof PositionIncrementAttribute) {
            Assertions.assertThat((int)((PositionIncrementAttribute)origAttr).getPositionIncrement()).isEqualTo(((PositionIncrementAttribute)copyAttr).getPositionIncrement());
        } else if (origAttr instanceof FlagsAttribute) {
            Assertions.assertThat((int)((FlagsAttribute)origAttr).getFlags()).isEqualTo(((FlagsAttribute)copyAttr).getFlags());
        } else if (origAttr instanceof TypeAttribute) {
            Assertions.assertThat((String)((TypeAttribute)origAttr).type()).isEqualTo((Object)((TypeAttribute)copyAttr).type());
        } else if (origAttr instanceof OffsetAttribute) {
            OffsetAttribute orig = (OffsetAttribute)origAttr;
            OffsetAttribute cop = (OffsetAttribute)copyAttr;
            Assertions.assertThat((int)orig.startOffset()).isEqualTo(cop.startOffset());
            Assertions.assertThat((int)orig.endOffset()).isEqualTo(cop.endOffset());
        } else {
            Assert.fail((String)"Unexpected Attribute implementation received");
        }
    }

    private static boolean compareReaders(Reader copy, Reader original) {
        if (original == null) {
            return copy == null;
        }
        try {
            int o = original.read();
            while (o != -1) {
                int c = copy.read();
                if (o != c) {
                    return false;
                }
                o = original.read();
            }
            return copy.read() == -1;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void assertDelete(DeleteLuceneWork work, DeleteLuceneWork copy) {
        ((ObjectAssert)Assertions.assertThat((Object)work.getEntityClass()).as("Delete.getEntityClass is not copied")).isEqualTo((Object)copy.getEntityClass());
        ((ObjectAssert)Assertions.assertThat((Object)work.getId()).as("Delete.getId is not copied")).isEqualTo((Object)copy.getId());
        ((ObjectAssert)Assertions.assertThat((Object)work.getDocument()).as("Delete.getDocument is not the same")).isEqualTo((Object)copy.getDocument());
        ((StringAssert)Assertions.assertThat((String)work.getIdInString()).as("Delete.getIdInString is not the same")).isEqualTo((Object)copy.getIdInString());
        ((MapAssert)Assertions.assertThat((Map)work.getFieldToAnalyzerMap()).as("Delete.getFieldToAnalyzerMap is not the same")).isEqualTo((Object)copy.getFieldToAnalyzerMap());
    }

    private static void assertPurgeAll(PurgeAllLuceneWork work, PurgeAllLuceneWork copy) {
        ((ObjectAssert)Assertions.assertThat((Object)work.getEntityClass()).as("PurgeAllLuceneWork.getEntityClass is not copied")).isEqualTo((Object)copy.getEntityClass());
    }

    static class SerializableStringReader
    extends Reader
    implements Serializable {
        private boolean read = false;

        SerializableStringReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.read) {
                return -1;
            }
            this.read = true;
            cbuf[off] = 2;
            return 1;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

