/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.serialization;

import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.AttributeImpl;
import org.fest.assertions.Assertions;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.service.impl.StandardServiceManager;
import org.hibernate.search.indexes.serialization.impl.CopyTokenStream;
import org.hibernate.search.indexes.serialization.impl.LuceneWorkSerializerImpl;
import org.hibernate.search.indexes.serialization.spi.SerializationProvider;
import org.hibernate.search.test.serialization.RemoteEntity;
import org.hibernate.search.test.util.SerializationTestHelper;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SerializationTest {
    @Rule
    public SearchFactoryHolder searchFactoryHolder = new SearchFactoryHolder(new Class[]{RemoteEntity.class});
    private SerializationProvider serializationProvider;

    @Before
    public void setUp() {
        StandardServiceManager serviceManager = new StandardServiceManager((SearchConfiguration)new SearchConfigurationForTest(), null);
        this.serializationProvider = (SerializationProvider)serviceManager.requestService(SerializationProvider.class);
    }

    @Test
    public void testWorkSerialization() throws Exception {
        LuceneWorkSerializerImpl workSerializer = new LuceneWorkSerializerImpl(this.serializationProvider, this.searchFactoryHolder.getSearchFactory());
        List<LuceneWork> works = this.buildLuceneWorkList();
        byte[] bytes = workSerializer.toSerializedModel(works);
        List copyOfWorks = workSerializer.toLuceneWorks(bytes);
        Assertions.assertThat((List)copyOfWorks).hasSize(works.size());
        for (int index = 0; index < works.size(); ++index) {
            SerializationTestHelper.assertLuceneWork(works.get(index), (LuceneWork)copyOfWorks.get(index));
        }
    }

    private List<LuceneWork> buildLuceneWorkList() throws Exception {
        ArrayList<LuceneWork> works = new ArrayList<LuceneWork>();
        works.add((LuceneWork)OptimizeLuceneWork.INSTANCE);
        works.add((LuceneWork)OptimizeLuceneWork.INSTANCE);
        works.add((LuceneWork)new OptimizeLuceneWork(RemoteEntity.class));
        works.add((LuceneWork)new PurgeAllLuceneWork(RemoteEntity.class));
        works.add((LuceneWork)new PurgeAllLuceneWork(RemoteEntity.class));
        works.add((LuceneWork)new DeleteLuceneWork((Serializable)Long.valueOf(123L), "123", RemoteEntity.class));
        works.add((LuceneWork)new DeleteLuceneWork((Serializable)((Object)"Sissi"), "Sissi", RemoteEntity.class));
        works.add((LuceneWork)new DeleteLuceneWork((Serializable)new URL("http://emmanuelbernard.com"), "http://emmanuelbernard.com", RemoteEntity.class));
        Document doc = this.buildDocumentWithNumericFields();
        HashMap<String, String> analyzers = new HashMap<String, String>();
        analyzers.put("godo", "ngram");
        works.add((LuceneWork)new AddLuceneWork((Serializable)Integer.valueOf(123), "123", RemoteEntity.class, doc, analyzers));
        doc = this.buildDocumentWithMultipleMixedTypeFields();
        works.add((LuceneWork)new UpdateLuceneWork((Serializable)Integer.valueOf(1234), "1234", RemoteEntity.class, doc));
        works.add((LuceneWork)new AddLuceneWork((Serializable)Integer.valueOf(125), "125", RemoteEntity.class, new Document()));
        return works;
    }

    private Document buildDocumentWithMultipleMixedTypeFields() {
        Document doc = new Document();
        Field field = new Field("StringF", "String field", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_OFFSETS);
        field.setBoost(3.0f);
        doc.add((IndexableField)field);
        field = new Field("StringF2", "String field 2", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_OFFSETS);
        doc.add((IndexableField)field);
        byte[] array = new byte[]{2, 5, 5, 8};
        field = new Field("binary", array, 0, array.length);
        doc.add((IndexableField)field);
        SerializationTestHelper.SerializableStringReader reader = new SerializationTestHelper.SerializableStringReader();
        field = new Field("ReaderField", (Reader)reader, Field.TermVector.WITH_OFFSETS);
        doc.add((IndexableField)field);
        List<List<AttributeImpl>> tokens = SerializationTestHelper.buildTokenStreamWithAttributes();
        CopyTokenStream tokenStream = new CopyTokenStream(tokens);
        field = new Field("tokenstream", (TokenStream)tokenStream, Field.TermVector.WITH_POSITIONS_OFFSETS);
        field.setBoost(3.0f);
        doc.add((IndexableField)field);
        return doc;
    }

    private Document buildDocumentWithNumericFields() {
        Document doc = new Document();
        DoubleField numField = new DoubleField("double", 23.0, Field.Store.NO);
        doc.add((IndexableField)numField);
        numField = new IntField("int", 23, Field.Store.NO);
        doc.add((IndexableField)numField);
        numField = new FloatField("float", 2.3f, Field.Store.NO);
        doc.add((IndexableField)numField);
        numField = new LongField("long", 23L, Field.Store.NO);
        doc.add((IndexableField)numField);
        return doc;
    }
}

