/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Workspace {
    private final Logger log = LoggerFactory.getLogger(Workspace.class);
    private final SearchFactoryImplementor searchFactoryImplementor;
    private static final Analyzer SIMPLE_ANALYZER = new SimpleAnalyzer();
    private final Map<DirectoryProvider, DPWorkspace> directorySpace = new HashMap<DirectoryProvider, DPWorkspace>(){

        @Override
        public DPWorkspace get(Object key) {
            DirectoryProvider dp = (DirectoryProvider)key;
            DPWorkspace directoryWorkSpace = (DPWorkspace)super.get(dp);
            if (directoryWorkSpace == null) {
                directoryWorkSpace = new DPWorkspace(dp);
                this.put(dp, directoryWorkSpace);
            }
            return directoryWorkSpace;
        }
    };
    private boolean isBatch = false;

    public Workspace(SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
    }

    public DocumentBuilder getDocumentBuilder(Class entity) {
        return this.searchFactoryImplementor.getDocumentBuilders().get(entity);
    }

    public IndexReader getIndexReader(DirectoryProvider provider, Class entity) {
        DPWorkspace space = this.directorySpace.get(provider);
        return space.getIndexReader(entity);
    }

    public IndexWriter getIndexWriter(DirectoryProvider provider) {
        return this.getIndexWriter(provider, null, false);
    }

    public IndexWriter getIndexWriter(DirectoryProvider provider, Class entity, boolean modificationOperation) {
        DPWorkspace space = this.directorySpace.get(provider);
        return space.getIndexWriter(entity, modificationOperation);
    }

    private void cleanUp(SearchException originalException) {
        SearchException raisedException = originalException;
        for (DPWorkspace space : this.directorySpace.values()) {
            try {
                space.closeIndexReader();
            }
            catch (IOException e) {
                if (raisedException != null) {
                    this.log.error("Subsequent Exception while closing IndexReader", (Throwable)e);
                    continue;
                }
                raisedException = new SearchException("Exception while closing IndexReader", e);
            }
        }
        for (DPWorkspace space : this.directorySpace.values()) {
            if (space.needsOptimization()) continue;
            raisedException = this.closeWriterAndUnlock(space, raisedException);
        }
        for (DPWorkspace space : this.directorySpace.values()) {
            if (!space.needsOptimization()) continue;
            if (raisedException == null) {
                OptimizerStrategy optimizerStrategy = space.getOptimizerStrategy();
                optimizerStrategy.addTransaction(space.countOperations());
                try {
                    optimizerStrategy.optimize(this);
                }
                catch (SearchException e) {
                    raisedException = new SearchException("Exception while optimizing directoryProvider: " + space.getDirectory().toString(), e);
                }
            }
            raisedException = this.closeWriterAndUnlock(space, raisedException);
        }
        if (raisedException != null) {
            throw raisedException;
        }
    }

    private SearchException closeWriterAndUnlock(DPWorkspace space, SearchException raisedException) {
        try {
            space.closeIndexWriter();
        }
        catch (IOException e) {
            if (raisedException != null) {
                this.log.error("Subsequent Exception while closing IndexWriter", (Throwable)e);
            }
            raisedException = new SearchException("Exception while closing IndexWriter", e);
        }
        space.unLock();
        return raisedException;
    }

    public void clean() {
        this.cleanUp(null);
    }

    public void optimize(DirectoryProvider provider) {
        DPWorkspace space = this.directorySpace.get(provider);
        OptimizerStrategy optimizerStrategy = space.getOptimizerStrategy();
        space.setOptimizationForced();
        optimizerStrategy.optimizationForced();
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public void setBatch(boolean isBatch) {
        this.isBatch = isBatch;
    }

    private class DPWorkspace {
        private final DirectoryProvider directoryProvider;
        private final Lock lock;
        private IndexReader reader;
        private IndexWriter writer;
        private boolean locked = false;
        private boolean optimizationForced = false;
        private long operations = 0L;

        DPWorkspace(DirectoryProvider dp) {
            this.directoryProvider = dp;
            this.lock = Workspace.this.searchFactoryImplementor.getDirectoryProviderLock(dp);
        }

        public boolean needsOptimization() {
            return this.isLocked() && !this.isOptimizationForced();
        }

        void setOptimizationForced() {
            this.optimizationForced = true;
        }

        Directory getDirectory() {
            return this.directoryProvider.getDirectory();
        }

        long countOperations() {
            return this.operations;
        }

        OptimizerStrategy getOptimizerStrategy() {
            return Workspace.this.searchFactoryImplementor.getOptimizerStrategy(this.directoryProvider);
        }

        boolean isOptimizationForced() {
            return this.optimizationForced;
        }

        boolean isLocked() {
            return this.locked;
        }

        IndexWriter getIndexWriter(Class entity, boolean modificationOperation) {
            try {
                this.closeIndexReader();
            }
            catch (IOException e) {
                throw new SearchException("Exception while closing IndexReader", e);
            }
            if (modificationOperation) {
                ++this.operations;
            }
            if (this.writer != null) {
                return this.writer;
            }
            this.lock();
            try {
                DocumentBuilder<Object> documentBuilder = Workspace.this.searchFactoryImplementor.getDocumentBuilders().get(entity);
                Analyzer analyzer = entity != null ? documentBuilder.getAnalyzer() : SIMPLE_ANALYZER;
                this.writer = new IndexWriter(this.directoryProvider.getDirectory(), analyzer, false);
                if (entity != null) {
                    this.writer.setSimilarity(documentBuilder.getSimilarity());
                }
                LuceneIndexingParameters indexingParams = Workspace.this.searchFactoryImplementor.getIndexingParameters(this.directoryProvider);
                indexingParams.applyToWriter(this.writer, Workspace.this.isBatch);
            }
            catch (IOException e) {
                Workspace.this.cleanUp(new SearchException("Unable to open IndexWriter" + (entity != null ? " for " + entity : ""), e));
            }
            return this.writer;
        }

        IndexReader getIndexReader(Class entity) {
            if (this.writer != null) {
                throw new AssertionFailure("Tries to read for update an index while a writer is accessed for " + entity);
            }
            ++this.operations;
            if (this.reader != null) {
                return this.reader;
            }
            this.lock();
            try {
                this.reader = IndexReader.open(this.directoryProvider.getDirectory());
            }
            catch (IOException e) {
                Workspace.this.cleanUp(new SearchException("Unable to open IndexReader for " + entity, e));
            }
            return this.reader;
        }

        void unLock() {
            if (this.locked) {
                this.lock.unlock();
                this.locked = false;
            }
        }

        void lock() {
            if (!this.locked) {
                this.lock.lock();
                this.locked = true;
            }
        }

        void closeIndexReader() throws IOException {
            IndexReader toClose = this.reader;
            this.reader = null;
            if (toClose != null) {
                toClose.close();
            }
        }

        void closeIndexWriter() throws IOException {
            IndexWriter toClose = this.writer;
            this.writer = null;
            if (toClose != null) {
                toClose.close();
            }
        }
    }
}

