/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaskedProperty
extends Properties
implements Serializable {
    private static final long serialVersionUID = -593307257383085113L;
    private transient Logger log = LoggerFactory.getLogger(MaskedProperty.class);
    private final Properties masked;
    private final Properties fallBack;
    private final String radix;

    public MaskedProperty(Properties propsToMask, String mask) {
        this(propsToMask, mask, null);
    }

    public MaskedProperty(Properties propsToMask, String mask, Properties propsFallBack) {
        if (propsToMask == null || mask == null) {
            throw new IllegalArgumentException();
        }
        this.masked = propsToMask;
        this.radix = mask + ".";
        this.fallBack = propsFallBack;
    }

    @Override
    public String getProperty(String key) {
        String compositeKey = this.radix + key;
        String value = this.masked.getProperty(compositeKey);
        if (value != null) {
            this.log.trace("found a match for key: [{}] value: {}", (Object)compositeKey, (Object)value);
            return value;
        }
        if (this.fallBack != null) {
            return this.fallBack.getProperty(key);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        return this.getProperty(key.toString()) != null;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    @Override
    public void list(PrintStream out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void list(PrintWriter out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Enumeration<?> propertyNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(OutputStream out, String comments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object setProperty(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Enumeration<Object> elements() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        if (this.fallBack == null) {
            return this.masked.isEmpty();
        }
        return this.masked.isEmpty() && this.fallBack.isEmpty();
    }

    @Override
    public Enumeration<Object> keys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Object> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void rehash() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.masked.toString();
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.fallBack == null ? 0 : this.fallBack.hashCode();
        result = 31 * result + this.masked.hashCode();
        result = 31 * result + this.radix.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaskedProperty other = (MaskedProperty)obj;
        if (this.fallBack == null ? other.fallBack != null : !this.fallBack.equals(other.fallBack)) {
            return false;
        }
        if (!this.masked.equals(other.masked)) {
            return false;
        }
        return this.radix.equals(other.radix);
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.log = LoggerFactory.getLogger(MaskedProperty.class);
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.defaultWriteObject();
    }
}

