/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter;

import java.util.Properties;
import org.apache.lucene.search.Filter;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.util.SoftLimitMRUCache;

public class MRUFilterCachingStrategy
implements FilterCachingStrategy {
    private static final int DEFAULT_SIZE = 128;
    private SoftLimitMRUCache cache;
    private static final String SIZE = "hibernate.search.filter.cache_strategy.size";

    public void initialize(Properties properties) {
        int size = ConfigurationParseHelper.getIntValue(properties, SIZE, 128);
        this.cache = new SoftLimitMRUCache(size);
    }

    public Filter getCachedFilter(FilterKey key) {
        return (Filter)this.cache.get((Object)key);
    }

    public void addCachedFilter(FilterKey key, Filter filter) {
        this.cache.put((Object)key, (Object)filter);
    }
}

