/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.Loader;
import org.hibernate.search.engine.ObjectLoader;
import org.hibernate.search.engine.ObjectLoaderHelper;
import org.hibernate.search.engine.SearchFactoryImplementor;

public class MultiClassesQueryLoader
implements Loader {
    private Session session;
    private SearchFactoryImplementor searchFactoryImplementor;
    private List<RootEntityMetadata> entityMatadata;
    private ObjectLoader objectLoader;

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor) {
        this.session = session;
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.objectLoader = new ObjectLoader();
        this.objectLoader.init(session, searchFactoryImplementor);
    }

    public void setEntityTypes(Class[] entityTypes) {
        List<Class> safeEntityTypes;
        if (entityTypes.length == 0) {
            safeEntityTypes = new ArrayList<Class>();
            for (Map.Entry entry : this.searchFactoryImplementor.getDocumentBuilders().entrySet()) {
                if (!((DocumentBuilder)entry.getValue()).isRoot()) continue;
                safeEntityTypes.add((Class)entry.getKey());
            }
        } else {
            safeEntityTypes = Arrays.asList(entityTypes);
        }
        this.entityMatadata = new ArrayList<RootEntityMetadata>(safeEntityTypes.size());
        for (Class clazz : safeEntityTypes) {
            this.entityMatadata.add(new RootEntityMetadata(clazz, this.searchFactoryImplementor, this.session));
        }
    }

    public Object load(EntityInfo entityInfo) {
        return ObjectLoaderHelper.load(entityInfo, this.session);
    }

    public List load(EntityInfo ... entityInfos) {
        if (entityInfos.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (entityInfos.length == 1) {
            Object entity = this.load(entityInfos[0]);
            if (entity == null) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(entity);
            return list;
        }
        HashMap<RootEntityMetadata, ArrayList<EntityInfo>> entityinfoBuckets = new HashMap<RootEntityMetadata, ArrayList<EntityInfo>>(this.entityMatadata.size());
        for (EntityInfo entityInfo : entityInfos) {
            boolean found = false;
            for (RootEntityMetadata rootEntityInfo : this.entityMatadata) {
                if (!rootEntityInfo.mappedSubclasses.contains(entityInfo.clazz)) continue;
                ArrayList<EntityInfo> bucket = (ArrayList<EntityInfo>)entityinfoBuckets.get(rootEntityInfo);
                if (bucket == null) {
                    bucket = new ArrayList<EntityInfo>();
                    entityinfoBuckets.put(rootEntityInfo, bucket);
                }
                bucket.add(entityInfo);
                found = true;
                break;
            }
            if (found) continue;
            throw new AssertionFailure("Could not find root entity for " + entityInfo.clazz);
        }
        for (Map.Entry entry : entityinfoBuckets.entrySet()) {
            RootEntityMetadata key = (RootEntityMetadata)entry.getKey();
            List value = (List)entry.getValue();
            EntityInfo[] bucketEntityInfos = value.toArray(new EntityInfo[value.size()]);
            if (key.useObjectLoader) {
                this.objectLoader.load(bucketEntityInfos);
                continue;
            }
            ObjectLoaderHelper.initializeObjects(bucketEntityInfos, key.criteria, key.rootEntity, this.searchFactoryImplementor);
        }
        return ObjectLoaderHelper.returnAlreadyLoadedObjectsInCorrectOrder(entityInfos, this.session);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootEntityMetadata {
        public final Class<?> rootEntity;
        public final Set<Class<?>> mappedSubclasses;
        private final Criteria criteria;
        public final boolean useObjectLoader;

        RootEntityMetadata(Class<?> rootEntity, SearchFactoryImplementor searchFactoryImplementor, Session session) {
            this.rootEntity = rootEntity;
            DocumentBuilder<?> provider = searchFactoryImplementor.getDocumentBuilder(rootEntity);
            if (provider == null) {
                throw new AssertionFailure("Provider not found for class: " + rootEntity);
            }
            this.mappedSubclasses = provider.getMappedSubclasses();
            this.criteria = session.createCriteria(rootEntity);
            this.useObjectLoader = !provider.isSafeFromTupleId();
        }
    }
}

