/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.Similarity;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.impl.SolrAnalyzerBuilder;
import org.hibernate.search.util.DelegateNamedAnalyzer;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitContext {
    private final Map<String, AnalyzerDef> analyzerDefs = new HashMap<String, AnalyzerDef>();
    private final List<DelegateNamedAnalyzer> lazyAnalyzers = new ArrayList<DelegateNamedAnalyzer>();
    private final Analyzer defaultAnalyzer;
    private final Similarity defaultSimilarity;
    private final boolean solrPresent;
    private final boolean jpaPresent;

    public InitContext(SearchConfiguration cfg) {
        this.defaultAnalyzer = this.initAnalyzer(cfg);
        this.defaultSimilarity = this.initSimilarity(cfg);
        this.solrPresent = this.isPresent("org.apache.solr.analysis.TokenizerFactory");
        this.jpaPresent = this.isPresent("javax.persistence.Id");
    }

    public void addAnalyzerDef(AnalyzerDef ann) {
        if (ann == null || this.analyzerDefs.put(ann.name(), ann) != null) {
            // empty if block
        }
    }

    public Analyzer buildLazyAnalyzer(String name) {
        DelegateNamedAnalyzer delegateNamedAnalyzer = new DelegateNamedAnalyzer(name);
        this.lazyAnalyzers.add(delegateNamedAnalyzer);
        return delegateNamedAnalyzer;
    }

    public List<DelegateNamedAnalyzer> getLazyAnalyzers() {
        return this.lazyAnalyzers;
    }

    private Analyzer initAnalyzer(SearchConfiguration cfg) {
        Analyzer defaultAnalyzer;
        Class analyzerClass;
        String analyzerClassName = cfg.getProperty("hibernate.search.analyzer");
        if (analyzerClassName != null) {
            try {
                analyzerClass = ReflectHelper.classForName((String)analyzerClassName);
            }
            catch (Exception e) {
                return this.buildLazyAnalyzer(analyzerClassName);
            }
        } else {
            analyzerClass = StandardAnalyzer.class;
        }
        try {
            defaultAnalyzer = (Analyzer)analyzerClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new SearchException("Lucene analyzer does not implement " + Analyzer.class.getName() + ": " + analyzerClassName, e);
        }
        catch (Exception e) {
            throw new SearchException("Failed to instantiate lucene analyzer with type " + analyzerClassName, e);
        }
        return defaultAnalyzer;
    }

    private Similarity initSimilarity(SearchConfiguration cfg) {
        Similarity defaultSimilarity;
        Class similarityClass;
        String similarityClassName = cfg.getProperty("hibernate.search.similarity");
        if (similarityClassName != null) {
            try {
                similarityClass = ReflectHelper.classForName((String)similarityClassName);
            }
            catch (Exception e) {
                throw new SearchException("Lucene Similarity class '" + similarityClassName + "' defined in property '" + "hibernate.search.similarity" + "' could not be found.", e);
            }
        } else {
            similarityClass = null;
        }
        if (similarityClass == null) {
            return Similarity.getDefault();
        }
        try {
            defaultSimilarity = (Similarity)similarityClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new SearchException("Lucene similarity does not extend " + Similarity.class.getName() + ": " + similarityClassName, e);
        }
        catch (Exception e) {
            throw new SearchException("Failed to instantiate lucene similarity with type " + similarityClassName, e);
        }
        return defaultSimilarity;
    }

    public Analyzer getDefaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public Similarity getDefaultSimilarity() {
        return this.defaultSimilarity;
    }

    public Map<String, Analyzer> initLazyAnalyzers() {
        HashMap<String, Analyzer> initializedAnalyzers = new HashMap<String, Analyzer>(this.analyzerDefs.size());
        for (DelegateNamedAnalyzer delegateNamedAnalyzer : this.lazyAnalyzers) {
            String name = delegateNamedAnalyzer.getName();
            if (initializedAnalyzers.containsKey(name)) {
                delegateNamedAnalyzer.setDelegate((Analyzer)initializedAnalyzers.get(name));
                continue;
            }
            if (this.analyzerDefs.containsKey(name)) {
                Analyzer analyzer = this.buildAnalyzer(this.analyzerDefs.get(name));
                delegateNamedAnalyzer.setDelegate(analyzer);
                initializedAnalyzers.put(name, analyzer);
                continue;
            }
            throw new SearchException("Analyzer found with an unknown definition: " + name);
        }
        for (Map.Entry entry : this.analyzerDefs.entrySet()) {
            if (initializedAnalyzers.containsKey(entry.getKey())) continue;
            Analyzer analyzer = this.buildAnalyzer((AnalyzerDef)entry.getValue());
            initializedAnalyzers.put((String)entry.getKey(), analyzer);
        }
        return Collections.unmodifiableMap(initializedAnalyzers);
    }

    private Analyzer buildAnalyzer(AnalyzerDef analyzerDef) {
        if (!this.solrPresent) {
            throw new SearchException("Use of @AnalyzerDef while Solr is not present in the classpath. Add apache-solr-analyzer.jar");
        }
        return SolrAnalyzerBuilder.buildAnalyzer(analyzerDef);
    }

    public boolean isJpaPresent() {
        return this.jpaPresent;
    }

    private boolean isPresent(String classname) {
        try {
            ReflectHelper.classForName((String)classname, InitContext.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

