/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.util.LoggerFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGroupsMasterMessageListener
implements Receiver {
    private static final Logger log = LoggerFactory.make();
    private SearchFactoryImplementor searchFactory;

    public JGroupsMasterMessageListener(SearchFactoryImplementor searchFactory) {
        this.searchFactory = searchFactory;
    }

    public void receive(Message message) {
        List queue;
        try {
            queue = (List)message.getObject();
        }
        catch (ClassCastException e) {
            log.error("Illegal object retrieved from message.", (Throwable)e);
            return;
        }
        if (queue != null && !queue.isEmpty()) {
            log.debug("There are {} Lucene docs received from slave node {} to be processed by master", (Object)queue.size(), (Object)message.getSrc());
            Runnable worker = this.getWorker(queue);
            worker.run();
        } else {
            log.warn("Received null or empty Lucene works list in message.");
        }
    }

    private Runnable getWorker(List<LuceneWork> queue) {
        Runnable processor = this.searchFactory.getBackendQueueProcessorFactory().getProcessor(queue);
        return processor;
    }

    public byte[] getState() {
        return null;
    }

    public void setState(byte[] state) {
    }

    public void viewAccepted(View view) {
        log.info("Received new cluster view: {}", (Object)view);
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }
}

