/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.PerDPResources;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkVisitor;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

class PerDPQueueProcessor
implements Runnable {
    private static final Logger log = LoggerFactory.make();
    private final Workspace workspace;
    private final LuceneWorkVisitor worker;
    private final ExecutorService executor;
    private final boolean exclusiveIndexUsage;
    private final List<LuceneWork> workOnWriter = new ArrayList<LuceneWork>();
    private boolean batchmode = false;

    public PerDPQueueProcessor(PerDPResources resources) {
        this.worker = resources.getVisitor();
        this.workspace = resources.getWorkspace();
        this.executor = resources.getExecutor();
        this.exclusiveIndexUsage = resources.isExclusiveIndexUsageEnabled();
    }

    public void addWork(LuceneWork work) {
        if (work.isBatch()) {
            this.batchmode = true;
            log.debug("Batch mode enabled");
        }
        this.workOnWriter.add(work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.workOnWriter.isEmpty()) {
            return;
        }
        log.debug("Opening an IndexWriter for update");
        IndexWriter indexWriter = this.workspace.getIndexWriter(this.batchmode);
        try {
            for (LuceneWork lw : this.workOnWriter) {
                lw.getWorkDelegate(this.worker).performWork(lw, indexWriter);
            }
            this.workspace.commitIndexWriter();
            this.performOptimizations();
        }
        finally {
            if (!this.exclusiveIndexUsage) {
                this.workspace.closeIndexWriter();
            }
        }
    }

    private void performOptimizations() {
        this.workspace.optimizerPhase();
    }

    public ExecutorService getOwningExecutor() {
        return this.executor;
    }
}

