/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.PerDPQueueProcessor;
import org.hibernate.search.backend.impl.lucene.PerDPResources;
import org.hibernate.search.backend.impl.lucene.PerDirectoryWorkProcessor;
import org.hibernate.search.store.DirectoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueueProcessors
implements PerDirectoryWorkProcessor {
    private final Map<DirectoryProvider, PerDPResources> resourcesMap;
    private final Map<DirectoryProvider, PerDPQueueProcessor> dpProcessors = new HashMap<DirectoryProvider, PerDPQueueProcessor>();

    QueueProcessors(Map<DirectoryProvider, PerDPResources> resourcesMap) {
        this.resourcesMap = resourcesMap;
    }

    public void addWorkToDpProcessor(DirectoryProvider dp, LuceneWork work) {
        if (!this.dpProcessors.containsKey(dp)) {
            this.dpProcessors.put(dp, new PerDPQueueProcessor(this.resourcesMap.get(dp)));
        }
        PerDPQueueProcessor processor = this.dpProcessors.get(dp);
        processor.addWork(work);
    }

    void runAll(boolean sync) throws InterruptedException {
        if (sync) {
            this.runAllWaiting();
        } else {
            this.runAllAsync();
        }
    }

    private void runAllAsync() {
        for (PerDPQueueProcessor process : this.dpProcessors.values()) {
            ExecutorService executor = process.getOwningExecutor();
            executor.execute(process);
        }
    }

    private void runAllWaiting() throws InterruptedException {
        ArrayList<FutureTask<Object>> futures = new ArrayList<FutureTask<Object>>(this.dpProcessors.size());
        for (PerDPQueueProcessor perDPQueueProcessor : this.dpProcessors.values()) {
            ExecutorService executor = perDPQueueProcessor.getOwningExecutor();
            FutureTask<Object> f = new FutureTask<Object>(perDPQueueProcessor, null);
            futures.add(f);
            executor.execute(f);
        }
        for (Future future : futures) {
            if (future.isDone()) continue;
            try {
                future.get();
            }
            catch (CancellationException ignore) {
            }
            catch (ExecutionException ignore) {}
        }
    }
}

