/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import org.apache.solr.analysis.TokenizerFactory;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.CalendarBridgeMapping;
import org.hibernate.search.cfg.ContainedInMapping;
import org.hibernate.search.cfg.DateBridgeMapping;
import org.hibernate.search.cfg.DocumentIdMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FieldMapping;
import org.hibernate.search.cfg.IndexEmbeddedMapping;
import org.hibernate.search.cfg.PropertyDescriptor;
import org.hibernate.search.cfg.SearchMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMapping {
    private SearchMapping mapping;
    private EntityDescriptor entity;
    private PropertyDescriptor property;

    public PropertyMapping(String name, ElementType type, EntityDescriptor entity, SearchMapping mapping) {
        this.mapping = mapping;
        this.entity = entity;
        this.property = entity.getProperty(name, type);
    }

    public DocumentIdMapping documentId() {
        return new DocumentIdMapping(this.property, this.entity, this.mapping);
    }

    public FieldMapping field() {
        return new FieldMapping(this.property, this.entity, this.mapping);
    }

    public DateBridgeMapping dateBridge(Resolution resolution) {
        return new DateBridgeMapping(this.mapping, this.entity, this.property, resolution);
    }

    public CalendarBridgeMapping calendarBridge(Resolution resolution) {
        return new CalendarBridgeMapping(this.mapping, this.entity, this.property, resolution);
    }

    public PropertyMapping analyzerDiscriminator(Class<? extends Discriminator> discriminator) {
        HashMap<String, Object> analyzerDiscriminatorAnn = new HashMap<String, Object>();
        analyzerDiscriminatorAnn.put("impl", discriminator);
        this.property.setAnalyzerDiscriminator(analyzerDiscriminatorAnn);
        return this;
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerFactory, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }

    public IndexEmbeddedMapping indexEmbedded() {
        return new IndexEmbeddedMapping(this.mapping, this.property, this.entity);
    }

    public ContainedInMapping containedIn() {
        return new ContainedInMapping(this.mapping, this.property, this.entity);
    }
}

