/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.Similarity;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.impl.SolrAnalyzerBuilder;
import org.hibernate.search.util.DelegateNamedAnalyzer;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.PluginLoader;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitContext {
    private static final Logger log = LoggerFactory.make();
    private final Map<String, AnalyzerDef> analyzerDefs = new HashMap<String, AnalyzerDef>();
    private final List<DelegateNamedAnalyzer> lazyAnalyzers = new ArrayList<DelegateNamedAnalyzer>();
    private final Analyzer defaultAnalyzer;
    private final Similarity defaultSimilarity;
    private final boolean solrPresent;
    private final boolean jpaPresent;

    public InitContext(SearchConfiguration cfg) {
        this.defaultAnalyzer = this.initAnalyzer(cfg);
        this.defaultSimilarity = this.initSimilarity(cfg);
        this.solrPresent = this.isPresent("org.apache.solr.analysis.TokenizerFactory");
        this.jpaPresent = this.isPresent("javax.persistence.Id");
    }

    public void addAnalyzerDef(AnalyzerDef ann) {
        if (ann == null || this.analyzerDefs.put(ann.name(), ann) != null) {
            // empty if block
        }
    }

    public Analyzer buildLazyAnalyzer(String name) {
        DelegateNamedAnalyzer delegateNamedAnalyzer = new DelegateNamedAnalyzer(name);
        this.lazyAnalyzers.add(delegateNamedAnalyzer);
        return delegateNamedAnalyzer;
    }

    public List<DelegateNamedAnalyzer> getLazyAnalyzers() {
        return this.lazyAnalyzers;
    }

    private Analyzer initAnalyzer(SearchConfiguration cfg) {
        Class analyzerClass;
        String analyzerClassName = cfg.getProperty("hibernate.search.analyzer");
        if (analyzerClassName != null) {
            try {
                analyzerClass = ReflectHelper.classForName((String)analyzerClassName);
            }
            catch (Exception e) {
                return this.buildLazyAnalyzer(analyzerClassName);
            }
        } else {
            analyzerClass = StandardAnalyzer.class;
        }
        Analyzer defaultAnalyzer = PluginLoader.instanceFromClass(Analyzer.class, analyzerClass, "Lucene analyzer");
        return defaultAnalyzer;
    }

    private Similarity initSimilarity(SearchConfiguration cfg) {
        String similarityClassName = cfg.getProperty("hibernate.search.similarity");
        Similarity defaultSimilarity = StringHelper.isEmpty((String)similarityClassName) ? Similarity.getDefault() : PluginLoader.instanceFromName(Similarity.class, similarityClassName, InitContext.class, "default similarity");
        log.debug("Using default similarity implementation: {}", (Object)defaultSimilarity.getClass().getName());
        return defaultSimilarity;
    }

    public Analyzer getDefaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public Similarity getDefaultSimilarity() {
        return this.defaultSimilarity;
    }

    public Map<String, Analyzer> initLazyAnalyzers() {
        HashMap<String, Analyzer> initializedAnalyzers = new HashMap<String, Analyzer>(this.analyzerDefs.size());
        for (DelegateNamedAnalyzer delegateNamedAnalyzer : this.lazyAnalyzers) {
            String name = delegateNamedAnalyzer.getName();
            if (initializedAnalyzers.containsKey(name)) {
                delegateNamedAnalyzer.setDelegate((Analyzer)initializedAnalyzers.get(name));
                continue;
            }
            if (this.analyzerDefs.containsKey(name)) {
                Analyzer analyzer = this.buildAnalyzer(this.analyzerDefs.get(name));
                delegateNamedAnalyzer.setDelegate(analyzer);
                initializedAnalyzers.put(name, analyzer);
                continue;
            }
            throw new SearchException("Analyzer found with an unknown definition: " + name);
        }
        for (Map.Entry entry : this.analyzerDefs.entrySet()) {
            if (initializedAnalyzers.containsKey(entry.getKey())) continue;
            Analyzer analyzer = this.buildAnalyzer((AnalyzerDef)entry.getValue());
            initializedAnalyzers.put((String)entry.getKey(), analyzer);
        }
        return Collections.unmodifiableMap(initializedAnalyzers);
    }

    private Analyzer buildAnalyzer(AnalyzerDef analyzerDef) {
        if (!this.solrPresent) {
            throw new SearchException("Use of @AnalyzerDef while Solr is not present in the classpath. Add apache-solr-analyzer.jar");
        }
        return SolrAnalyzerBuilder.buildAnalyzer(analyzerDef);
    }

    public boolean isJpaPresent() {
        return this.jpaPresent;
    }

    private boolean isPresent(String classname) {
        try {
            ReflectHelper.classForName((String)classname, InitContext.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

